package ru.yandex.iex.proxy.cacheupdate;

import ru.yandex.json.dom.JsonObject;

public class FieldModificationSettings {
    // check cache only in case of field of new email equals this value
    private Object msgFieldValue;
    private JsonObject newValue;
    private boolean ignoreFirst; // modify all messages except for the first
    private boolean ignoreLast; // modify all messages except for the last

    public FieldModificationSettings(
        final Object msgFieldValue,
        final JsonObject newValue)
    {
        this(msgFieldValue, newValue, false, false);
    }

    // CSOFF: ParameterNumber
    public FieldModificationSettings(
        final Object msgFieldValue,
        final JsonObject newValue,
        final boolean ignoreFirst,
        final boolean ignoreLast)
    {
        this.msgFieldValue = msgFieldValue;
        this.newValue = newValue;
        this.ignoreFirst = ignoreFirst;
        this.ignoreLast = ignoreLast;
    }
    // CSON: ParameterNumber

    public Object msgFieldValue() {
        return msgFieldValue;
    }

    public JsonObject newValue() {
        return newValue;
    }

    public boolean ignoreFirst() {
        return ignoreFirst;
    }

    public boolean ignoreLast() {
        return ignoreLast;
    }
}
