package ru.yandex.iex.proxy.cacheupdate;

import java.util.List;

import org.apache.http.HttpHost;
import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.iex.proxy.AbstractContext;
import ru.yandex.iex.proxy.GenerateLuceneRequestHelper;
import ru.yandex.parser.uri.QueryConstructor;
import ru.yandex.search.proxy.SearchResultConsumerFactory;

public class HostsCallback
    extends AbstractProxySessionCallback<List<HttpHost>>
{
    private AbstractContext context;
    private String xIndexOperationQueueName;
    private PossibleUpdateCacheData possibleUpdateCacheData;
    private FutureCallback<Object> callback;

    //CSOFF: ParameterNumber
    public HostsCallback(
        final AbstractContext context,
        final String xIndexOperationQueueName,
        final PossibleUpdateCacheData possibleUpdateCacheData,
        final FutureCallback<Object> callback)
    {
        super(context.session());
        this.context = context;
        this.xIndexOperationQueueName = xIndexOperationQueueName;
        this.possibleUpdateCacheData = possibleUpdateCacheData;
        this.callback = callback;
    }
    //CSON: ParameterNumber

    @Override
    public synchronized void completed(final List<HttpHost> hosts) {
        AsyncClient searchClient = context.iexProxy().searchClient()
            .adjust(context.session().context());
        try {
            QueryConstructor query = new QueryConstructor(
                GenerateLuceneRequestHelper.getLuceneRequestPrefix()
                + possibleUpdateCacheData.uid());
            query.append(
                "service",
                context.iexProxy().config().factsIndexingQueueName());
            possibleUpdateCacheData.query(query);
            searchClient.execute(
                hosts,
                new BasicAsyncRequestProducerGenerator(query.toString()),
                SearchResultConsumerFactory.OK,
                context.session().listener()
                    .createContextGeneratorFor(searchClient),
                new UpdateFactCallback(
                    context,
                    xIndexOperationQueueName,
                    possibleUpdateCacheData,
                    callback));
        } catch (BadRequestException e) {
            e.printStackTrace();
        }
    }
}
