package ru.yandex.iex.proxy.cacheupdate;

import java.util.Map;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.iex.proxy.GenerateLuceneRequestHelper;
import ru.yandex.parser.uri.QueryConstructor;

public class PossibleUpdateCacheData {
    //private static final String TRUE = "true";
    private Long uid;
    private String mid;
    private Long receivedDate;
    private Map<String, FieldModificationSettings> fieldSettings;
    private String searchFieldName;
    private String searchFieldValue;
    private Map<String, String> checkFields; // inside fact_data
    private String modifiedMidFieldName;
    private String requestText;
    private final int dayAgeLimit;
    private final int updateDepth;

    //CSOFF: ParameterNumber
    public PossibleUpdateCacheData(
        final Long uid,
        final String mid,
        final Long receivedDate,
        final CacheModificationSettings settings,
        final Map<String, FieldModificationSettings> fieldSettings,
        final String searchFieldValue,
        final Map<String, String> checkFields)
    {
        this.uid = uid;
        this.mid = mid;
        this.receivedDate = receivedDate;
        this.fieldSettings = fieldSettings;
        this.searchFieldName = settings.searchFieldName();
        this.searchFieldValue = searchFieldValue;
        this.checkFields = checkFields;
        this.modifiedMidFieldName = settings.modifiedMidFieldName();
        this.dayAgeLimit = settings.dayAgeLimit();
        this.requestText = generateRequestText(settings.factName());
        this.updateDepth = settings.updateDepth();
    }
    //CSON: ParameterNumber

    public Long uid() {
        return uid;
    }

    public String mid() {
        return mid;
    }

    public Map<String, FieldModificationSettings> fieldSettings() {
        return fieldSettings;
    }

    public String searchFieldName() {
        return searchFieldName;
    }

    public String searchFieldValue() {
        return searchFieldValue;
    }

    public String modifiedMidFieldName() {
        return modifiedMidFieldName;
    }

    public Map<String, String> checkFields() {
        return checkFields;
    }

    public String requestText() {
        return requestText;
    }

    public void query(final QueryConstructor query) throws BadRequestException {
        GenerateLuceneRequestHelper.query(
                query,
                searchFieldValue,
                requestText,
                "fact_name,fact_data,fact_mid",
                updateDepth);
    }

    private String generateRequestText(final String factName) {
        return GenerateLuceneRequestHelper.generateRequestText(
                factName,
                searchFieldName,
                searchFieldValue,
                receivedDate,
                dayAgeLimit);
    }
}
