package ru.yandex.iex.proxy.calendar;

import java.util.logging.Level;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.iex.proxy.IexProxy;
import ru.yandex.parser.searchmap.User;
import ru.yandex.parser.uri.QueryConstructor;
import ru.yandex.search.prefix.LongPrefix;
import ru.yandex.search.proxy.SearchResultConsumerFactory;
import ru.yandex.search.proxy.universal.PlainUniversalSearchProxyRequestContext;
import ru.yandex.search.result.SearchResult;

public class CalendarFactMidsSearcher {
    private static final String IEX = "iex";
    private static final String QUERY_CONSTRUCT_ERROR = "Query construct error";
    private static final String PREFIX = "prefix";
    private static final String SERVICE = "service";
    private static final String FACT_MID = "fact_mid";
    private static final String FACT_RECEIVED_DATE = "fact_received_date";

    private IexProxy iexProxy;
    private ProxySession session;
    private FutureCallback<SearchResult> callback;

    public CalendarFactMidsSearcher(
        final IexProxy iexProxy,
        final ProxySession session,
        final FutureCallback<SearchResult> callback)
    {
        this.iexProxy = iexProxy;
        this.session = session;
        this.callback = callback;
    }

    public void search(
        final Long uid,
        final String externalId,
        final String recurrenceId)
    {
        if (uid == null || externalId == null) {
            session.logger().warning("CalendarFactMidsSearcher warning, uid: "
                + uid + " or externalId: " + externalId + " is null");
            callback.completed(null);
            return;
        }
        QueryConstructor query = new QueryConstructor("/search?");
        try {
            query.append(PREFIX, uid);
            query.append(SERVICE, IEX);
            query.append("sort", FACT_RECEIVED_DATE);
            query.append("asc", "true");
            String text = "fact_event_id:\"" + externalId + '\"';
            if (recurrenceId != null) {
                text += " AND fact_event_recurrence_id:\""
                    + recurrenceId + '\"';
            }
            query.append("text", text);
            query.append("get", FACT_MID);
        } catch (BadRequestException e) {
            session.logger().log(Level.SEVERE, QUERY_CONSTRUCT_ERROR, e);
            callback.completed(null);
            return;
        }
        BasicAsyncRequestProducerGenerator generator =
            new BasicAsyncRequestProducerGenerator(query.toString());

        User user = new User(IEX, new LongPrefix(uid));

        PlainUniversalSearchProxyRequestContext requestContext =
            new PlainUniversalSearchProxyRequestContext(
                user,
                null,
                true,
                iexProxy.searchClient(),
                session.logger());

        session.logger().log(Level.INFO, "Search request: " + query.toString());

        iexProxy.parallelRequest(
            session,
            requestContext,
            generator,
            SearchResultConsumerFactory.OK,
            session.listener().createContextGeneratorFor(
                requestContext.client()),
            callback);
    }
}
