package ru.yandex.iex.proxy.calendar;

import java.util.ArrayList;
import java.util.List;
import java.util.function.LongFunction;
import java.util.logging.Level;

import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.protocol.HttpContext;

import ru.yandex.function.GenericFunction;
import ru.yandex.iex.proxy.IexProxy;
import ru.yandex.json.async.consumer.JsonStreamAsyncConsumer;
import ru.yandex.json.dom.ContainerFactory;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.parser.StringCollectors;

public class CalendarLogAsyncConsumer<T> extends JsonStreamAsyncConsumer<T, List<T>> {
    private IexProxy proxy;

    // CSOFF: ParameterNumber
    public CalendarLogAsyncConsumer(
        final HttpEntity entity,
        final GenericFunction<JsonObject, T, JsonException> consumer,
        final LongFunction<StringCollectors> stringCollectorsFactory,
        final ContainerFactory containerFactory,
        final IexProxy proxy)
        throws HttpException
    {
        super(entity, consumer, ArrayList::new, stringCollectorsFactory, containerFactory);
        this.proxy = proxy;
    }
    // CSON: ParameterNumber

    @Override
    protected List<T> buildResult(final HttpContext context) {
        List<T> result = new ArrayList<>();
        try {
            result = super.buildResult(context);
        } catch (Exception e) {
            proxy.logger().log(
                Level.SEVERE,
                "Calendar log json parsing failed",
                e);
            proxy.calendarLogParsingFailed();
        }
        return result;
    }
}
