package ru.yandex.iex.proxy.calendar;

import java.util.ArrayList;
import java.util.List;

import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonNull;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;

public final class CalendarLogParser {
    private static CalendarLogParser instance = new CalendarLogParser();

    private CalendarLogParser() {
    }

    public static CalendarLogParser getInstance() {
        return instance;
    }

    public CalendarLog parse(final JsonObject log) throws JsonException {
        if (log == null || log == JsonNull.INSTANCE) {
            return null;
        }
        CalendarLog result = null;
        List<Long> uids = new ArrayList<>();
        JsonMap eventInfo = log.get("event_info").asMap();
        String externalId = eventInfo.getString("external_id", "");
        String recurrenceId = eventInfo.getString("recurrence_id", "");
        JsonMap users = eventInfo.getMapOrNull("users");
        if (users != null && !users.isEmpty()) {
            List<JsonObject> updated = users.getListOrNull("updated");
            if (updated != null) {
                for (JsonObject user: updated) {
                    JsonObject uid = user.get("uid");
                    if (uid != null && uid != JsonNull.INSTANCE) {
                        uids.add(uid.asLong());
                    }
                }
            }
        }
        if (!uids.isEmpty() && !externalId.isEmpty()) {
            result = new CalendarLog(uids, externalId, recurrenceId);
        }
        return result;
    }
}
