package ru.yandex.iex.proxy.complaints;

import java.util.List;
import java.util.Map;

import ru.yandex.iex.proxy.AbstractHandlersContext;
import ru.yandex.iex.proxy.move.UpdateDataHolder;
import ru.yandex.stater.RequestInfo;
import ru.yandex.util.timesource.TimeSource;

public interface AbstractUserActionContext extends AbstractHandlersContext {
    long MILLIS = 1000L;

    String suid();

    void setSuid(final String suid);

    Long karma();

    void setKarma(final Long karma);

    UserAction action();

    Sources source();

    long actionDate();

    String login();

    void setLogin(final String login);

    Boolean showTabs();

    void setShowTabs(final boolean showTabs);

    Map<String, Long> recipients();             // Map: email -> uid

    Map<String, Long> senderUids();             // Map: email -> uid

    Map<Long, UpdateDataHolder> messages();     // Map: mid -> UpdateDataHolder

    void messages(final List<UpdateDataHolder> docs);

    Map<UserAction, List<Long>> actions();      // Map: action -> List of mids

    long startTime();

    default ImmutableComplaintsConfig complaintsConfig() {
        return iexProxy().config().complaintsConfig();
    }

    default void stat(final int status) {
        complaintsConfig().actionStater(action()).accept(
            new RequestInfo(
                TimeSource.INSTANCE.currentTimeMillis(),
                status,
                startTime(),
                startTime(),
                0L,
                0L));
    }
}
