package ru.yandex.iex.proxy.complaints;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.http.concurrent.FutureCallback;
import org.apache.http.message.BasicHeader;

import ru.yandex.client.so.shingler.ActivityShingles;
import ru.yandex.client.so.shingler.ComplScheme;
import ru.yandex.client.so.shingler.ComplShingles;
import ru.yandex.client.so.shingler.DictShinglerResult;
import ru.yandex.client.so.shingler.GeneralShingleInfo;
import ru.yandex.client.so.shingler.GeneralShingles;
import ru.yandex.client.so.shingler.MassShinglerResult;
import ru.yandex.client.so.shingler.SenderScheme;
import ru.yandex.client.so.shingler.SenderShingles;
import ru.yandex.client.so.shingler.Shingle;
import ru.yandex.client.so.shingler.ShingleException;
import ru.yandex.client.so.shingler.ShingleType;
import ru.yandex.client.so.shingler.Shingles;
import ru.yandex.client.so.shingler.UrlShingles;
import ru.yandex.client.so.shingler.config.ShinglerType;
import ru.yandex.http.config.ImmutableURIConfig;
import ru.yandex.http.util.AbstractFilterFutureCallback;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.HttpExceptionConverter;
import ru.yandex.http.util.MultiFutureCallback;
import ru.yandex.http.util.YandexHeaders;
import ru.yandex.http.util.nio.HeaderAsyncRequestProducerSupplier;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.http.util.nio.client.AsyncGetURIRequestProducerSupplier;
import ru.yandex.iex.proxy.IexProxy;
import ru.yandex.iex.proxy.move.UpdateDataExecutor;
import ru.yandex.iex.proxy.move.UpdateDataHolder;
import ru.yandex.json.async.consumer.JsonAsyncTypesafeDomConsumerFactory;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;
import ru.yandex.parser.string.BooleanParser;
import ru.yandex.parser.uri.QueryConstructor;

public class ComplaintProcessCallback extends UserActionProcessCallback {
    private static final String ACTIVITY = "activity";
    private static final String CNT = "cnt";
    private static final String DICT = "dict";
    private static final String SH = "sh";
    private static final String SHINGLES = "shingles";
    private static final String SENDER = "sender";
    private static final String URL = "url";

    private final AbstractUserActionContext context;

    public ComplaintProcessCallback(
        final AbstractUserActionContext context,
        final FutureCallback<List<UpdateDataHolder>> callback)
    {
        super(context, callback);
        this.context = context;
    }

    private static class ComplSologInfoCallback extends SologInfoCallback {
        public ComplSologInfoCallback(
            final AbstractUserActionContext context,
            final UserAction action,
            final List<Long> mids,
            final FutureCallback<Void> callback)
        {
            super(context, action, mids, callback);
        }

        @Override
        protected void processSologData(final String queueId, final JsonMap sologData) throws JsonException {
            super.processSologData(queueId, sologData);
            // boolean dictLoaded = false;
            if (sologData.containsKey(COMPL) && sologData.get(COMPL) != null) {
                try {
                    /*if (sologData.get(COMPL) instanceof JsonMap) {
                        JsonMap compl = sologData.get(COMPL).asMap();
                        dictLoaded = loadDictShingles(queueId, compl);
                    }*/
                    if (loadComplShingles(queueId, sologData.get(COMPL))) {
                        final MailMessageContext msgContext =
                            context.messages().get(queueIdMids.get(queueId)).context();
                        ComplShingles complShingles =
                            ((ComplShingles) msgContext.shinglersData().get(ShinglerType.COMPL));
                        context.messages().get(queueIdMids.get(queueId)).context().setUpComplShingles(complShingles);
                    } else {
                        context.session().logger().info(
                            "ComplSologInfoCallback.processSologData failed to parse COMPL-shingler's data");
                    }
                } catch (Exception e) {
                    context.session().logger().log(
                        Level.SEVERE,
                        "ComplaintProcessCallback: extracting of rules failed",
                        e);
                }
                loadActivityShingles(queueId, sologData.get(ACTIVITY));
                loadMassShingles(queueId, sologData.get(CNT));
                /*if (!dictLoaded) {
                    loadDictShingles(queueId, sologData);
                }*/
                loadSenderShingles(queueId, sologData.get(SENDER));
                loadUrlShingles(queueId, sologData.get(URL));
            }
        }

        private boolean loadActivityShingles(final String queueId, final JsonObject jsonObject) {
            if (jsonObject instanceof JsonList) {
                try {
                    ((ActivityShingles) context.messages().get(queueIdMids.get(queueId)).context().shinglersData()
                        .computeIfAbsent(ShinglerType.ACTIVITY, x -> new ActivityShingles()))
                        .loadUpdateRequest(jsonObject.asList());
                    return true;
                } catch (Exception e) {
                    context.session().logger().log(Level.SEVERE, "ComplaintProcessCallback failed to parse "
                        + "Activity-Shingler's data: " + e, e);
                }
            } else {
                context.session().logger().log(Level.SEVERE, "ComplaintProcessCallback failed to find "
                    + "Activity-Shingler's data");
            }
            return false;
        }

        private boolean loadMassShingles(final String queueId, final JsonObject jsonObject) {
            if (jsonObject instanceof JsonList) {
                try {
                    final MassShinglerResult shinglerResult = new MassShinglerResult(jsonObject.asList());
                    context.messages().get(queueIdMids.get(queueId)).context().setUpMassShingles(shinglerResult);
                    return true;
                } catch (JsonException | RuntimeException e) {
                    context.session().logger().log(Level.SEVERE, "ComplaintProcessCallback failed to parse "
                        + "Mass-Shingler's data: " + Arrays.toString(e.getStackTrace()), e);
                }
            } else {
                context.session().logger().log(Level.SEVERE, "ComplaintProcessCallback failed to find "
                    + "Mass-Shingler's data");
            }
            return false;
        }

        private boolean loadComplShingles(final String queueId, final JsonObject jsonObject) {
            try {
                final MailMessageContext msgContext = context.messages().get(queueIdMids.get(queueId)).context();
                if (jsonObject instanceof JsonMap) {
                    final JsonMap jsonMap = jsonObject.asMap();
                    if (jsonMap.containsKey(SH) && jsonMap.get(SH) != null) {
                        JsonObject shObj = jsonMap.get(SH);
                        if (shObj instanceof JsonMap) {
                            final JsonMap shinglesMap = shObj.asMap();
                            if (shinglesMap.containsKey(SHINGLES) && shinglesMap.get(SHINGLES) != null) {
                                msgContext.shinglersData().put(
                                    ShinglerType.COMPL,
                                    new ComplShingles(
                                        shinglesMap.getList(SHINGLES),
                                        new HashSet<>(Set.of(
                                            ComplScheme.TODAY_ABUSES,
                                            ComplScheme.HISTORY_ABUSES,
                                            ComplScheme.HISTORY_ABUSES_DAYS))));
                                return true;
                            }
                        }
                    }
                } else if (jsonObject instanceof JsonList) {
                    ((ComplShingles) msgContext.shinglersData()
                        .computeIfAbsent(ShinglerType.COMPL, x -> new ComplShingles()))
                        .loadUpdateRequest(jsonObject.asList());
                    return true;
                } else {
                    context.session().logger().log(Level.SEVERE, "ComplaintProcessCallback failed to find "
                        + "Compl-Shingler's data");
                }
            } catch (Exception e) {
                context.session().logger().log(Level.SEVERE, "ComplaintProcessCallback failed to parse "
                    + "Compl-Shingler's data: " + e, e);
            }
            return false;
        }

        @SuppressWarnings("unused")
        private boolean loadDictShingles(final String queueId, final JsonMap jsonMap) {
            if (jsonMap.containsKey(DICT) && jsonMap.get(DICT) != null) {
                JsonObject dictObj = jsonMap.get(DICT);
                if (dictObj instanceof JsonMap) {
                    try {
                        final MailMessageContext msgContext =
                            context.messages().get(queueIdMids.get(queueId)).context();
                        final JsonMap shinglesMap = dictObj.asMap();
                        if (shinglesMap.containsKey(SHINGLES) && shinglesMap.get(SHINGLES) != null) {
                            msgContext.shinglersData().put(
                                ShinglerType.DICT,
                                new DictShinglerResult(shinglesMap.getList(SHINGLES), msgContext.route().lowerName()));
                            return true;
                        }
                    } catch (Exception e) {
                        context.session().logger().log(Level.SEVERE, "ComplaintProcessCallback failed to parse "
                            + "Dict-Shingler's data: " + e, e);
                    }
                }
            } else {
                context.session().logger().log(Level.SEVERE, "ComplaintProcessCallback failed to find "
                    + "Dict-Shingler's data");
            }
            return false;
        }

        private boolean loadSenderShingles(final String queueId, final JsonObject jsonObject) {
            if (jsonObject instanceof JsonList) {
                try {
                    MailMessageContext msgContext = context.messages().get(queueIdMids.get(queueId)).context();
                    SenderShingles shingles = (SenderShingles) msgContext.shinglersData()
                        .computeIfAbsent(ShinglerType.SENDER, x -> new SenderShingles());
                    shingles.loadUpdateRequest(jsonObject.asList());
                    boolean dkim;
                    ArrayList<Object> one = new ArrayList<>();
                    one.add(1L);
                    for (GeneralShingleInfo<SenderScheme> shingleInfo : shingles.get(GeneralShingles.SHINGLE).values()) {
                        shingleInfo.remove(SenderScheme.SENDER_AD);
                        dkim = false;
                        for (Map.Entry<SenderScheme, Map<String, List<Object>>> entry : shingleInfo.entrySet()) {
                            Iterator<String> it = entry.getValue().keySet().iterator();
                            while (it.hasNext()) {
                                String key = it.next();
                                if (key.equals("dkim_spam") || key.equals("dkim_ham")) {
                                    dkim = true;
                                }
                                if (!entry.getKey().keyFields().contains(key)) {
                                    it.remove();
                                }
                            }
                        }
                        shingleInfo.get(SenderScheme.SENDER_TOTALS).put("c" + (msgContext.isSpam() ? "s" : "h"), one);
                        shingleInfo.get(SenderScheme.SENDER_2WEEKS).put(
                            "compl_" + (msgContext.isSpam() ? "spam" : "ham"),
                            one);
                        if (dkim && msgContext.isSpam()) {
                            shingleInfo.get(SenderScheme.SENDER_TOTALS).put("dkim_complaint_spam", one);
                        }
                    }
                    // context.session().logger().info("ComplaintProcessCallback loaded Sender-Shingler's data: "
                    //    + shingles);
                    return true;
                } catch (Exception e) {
                    context.session().logger().log(Level.SEVERE, "ComplaintProcessCallback failed to parse "
                        + "Sender-Shingler's data: " + e, e);
                }
            } else {
                context.session().logger().log(Level.SEVERE, "ComplaintProcessCallback failed to find "
                    + "Sender-Shingler's data");
            }
            return false;
        }

        private boolean loadUrlShingles(final String queueId, final JsonObject jsonObject) {
            if (jsonObject instanceof JsonList) {
                try {
                    ((UrlShingles) context.messages().get(queueIdMids.get(queueId)).context().shinglersData()
                        .computeIfAbsent(ShinglerType.URL, x -> new UrlShingles()))
                        .loadUpdateRequest(jsonObject.asList());
                    return true;
                } catch (Exception e) {
                    context.session().logger().log(Level.SEVERE, "ComplaintProcessCallback failed to parse "
                        + "Url-Shingler's data: " + e, e);
                }
            } else {
                context.session().logger().log(Level.SEVERE, "ComplaintProcessCallback failed to find "
                    + "Url-Shingler's data");
            }
            return false;
        }
    }

    private static class CmplSologgerCollback extends SologgerCallback {
        private static final String LOG = "log";
        private static final String RPUR = "rpur";
        private static final Pattern SHINGLE_RE =
            Pattern.compile("(?m)^t = (\\d+), s = \\d+, h = \\d+, .+? ([0-9a-f]+)(?:$| \\(.*?\\))$");
        private static final Pattern URL_SHINGLE_RE = Pattern.compile("\\S+ ([0-9A-F]+)");
        private static final Pattern PSNDR_RE = Pattern.compile("PSNDR_\\d+");

        private String psndrRule = null;

        public CmplSologgerCollback(
            final AbstractUserActionContext context,
            final Map<List<String>, Long> queueIdMids,
            final FutureCallback<Void> callback)
        {
            super(context, queueIdMids, callback);
        }

        @Override
        protected void processDeliveryLog(final String queueId, final Map<String, List<String>> headers) {
            super.processDeliveryLog(queueId, headers);
            Matcher m;
            Shingles shingles = new Shingles();
            if (headers.containsKey(LOG)) {
                for (final String shingleInfo : headers.get(LOG)) {
                    m = SHINGLE_RE.matcher(shingleInfo);
                    if (m.find()) {
                        shingles.add(ShingleType.fromId(Integer.parseInt(m.group(1))), new Shingle(m.group(2)));
                    }
                }
            }
            setUpMassShingles(queueId, shingles);

            Shingles urlShingles = new Shingles();
            if (headers.containsKey(RPUR)) {
                for (final String shingleInfo : headers.get(RPUR)) {
                    m = URL_SHINGLE_RE.matcher(shingleInfo);
                    if (m.find()) {
                        long shVal;
                        try {
                            shVal = Long.parseUnsignedLong(m.group(1), 16);
                        } catch (NumberFormatException e) {
                            shVal = 0;
                        }
                        if (shVal != 0) {
                            Shingle sh = new Shingle(shVal);
                            urlShingles.add(GeneralShingles.SHINGLE, sh);
                            //context.session().logger().info("SologgerCallback.processDeliveryLog: mid= "
                            //    + queueIdMids.get(queueId) + " urlShingle=" + sh + " for '" + m.group(1) + "'");
                        }
                    }
                }
            }
            try {
                setUpComplShingles(queueId, shingles);
                setUpSenderShingles(queueId, shingles);
                setUpUrlShingles(queueId, urlShingles);
            } catch (ShingleException e) {
                context.session().logger().log(
                    Level.SEVERE,
                    "SologgerCallback.processDeliveryLog failed to look up delivery-log for queueid: queueIds="
                        + queueId + ", dlvLog=" + headers,
                    e);
            }
        }

        @Override
        public void testRules(final String rule) {
            Matcher m = PSNDR_RE.matcher(rule);
            if (m.matches()) {
                psndrRule = m.group();
            }
        }

        private void setUpMassShingles(final String queueId, final Shingles massShingles) {
            MassShinglerResult massShinglerData = new MassShinglerResult(massShingles);
            context.messages().get(queueIdMids.get(queueId)).context().setUpMassShingles(massShinglerData);
        }

        private void setUpComplShingles(final String queueId, final Shingles complShingles) throws ShingleException {
            context.messages().get(queueIdMids.get(queueId)).context().setUpComplShingles(complShingles);
        }

        private void setUpSenderShingles(final String queueId, final Shingles massShingles) throws ShingleException {
            context.messages().get(queueIdMids.get(queueId)).context().setUpSenderShingles(massShingles, psndrRule);
        }

        private void setUpUrlShingles(final String queueId, final Shingles urlShingles) throws ShingleException {
            context.messages().get(queueIdMids.get(queueId)).context().setUpUrlShingles(urlShingles);
        }
    }

    @Override
    protected void finalizing() {
        for (final UpdateDataHolder data : context.messages().values()) {
            final MailMessageContext msgContext = data.context();
            if (msgContext.senderEmail() != null && msgContext.senderUid() == 0
                    && context.senderUids().containsKey(msgContext.senderEmail())) {
                msgContext.setSenderUid(context.senderUids().get(msgContext.senderEmail()));
            }
            for (final Map.Entry<String, Long> recipientInfo : context.recipients().entrySet()) {
                if (msgContext.recipients().containsKey(recipientInfo.getKey()) && recipientInfo.getValue() != 0L) {
                    msgContext.recipients().put(recipientInfo.getKey(), recipientInfo.getValue());
                }
            }
            /*if (msgContext.recipientEmail() != null && msgContext.recipients().get(msgContext.recipientEmail()) == 0
                    && context.recipients().containsKey(msgContext.recipientEmail())) {
                msgContext.recipients().put(
                        msgContext.recipientEmail(),
                        context.recipients().get(msgContext.recipientEmail()));
            }*/
            context.session().logger().info("ComplaintProcessCallback.finalizing: uid=" + context.uid() + ", mid="
                + msgContext.mid() + ", stid=" + msgContext.stid() + ", action=" + msgContext.action() + ", recipient="
                + msgContext.recipientEmail() + ", sender=" + msgContext.senderEmail() + ", senderUid="
                + msgContext.senderUid() + ", recipients="
                + Arrays.toString(msgContext.recipients().keySet().toArray()));
        }
        finalProcessing();
    }

    @Override
    protected void finalProcessing() {
        UserActionHandler.doFinalComplaintProcessing(context, callback);
    }

    @Override
    protected void auxiliaryRequests(final MultiFutureCallback<Void> multiCallback) {
        context.session().logger().info("ComplaintProcessCallback.completed auxiliaryRequests: actions="
                + context.actions().keySet());
        for (final Map.Entry<UserAction, List<Long>> actionInfo : context.actions().entrySet()) {
            context.session().logger().info("ComplaintProcessCallback.completed: action=" + actionInfo.getKey()
                + ", mids=" + actionInfo.getValue());
            if (actionInfo.getKey() == UserAction.SPAM || actionInfo.getKey() == UserAction.HAM) {
                UserActionHandler.requestMsgAbuses(
                    context,
                    actionInfo.getValue(),
                    actionInfo.getKey() == UserAction.SPAM,
                    TraceFutureCallback.wrap(
                        new AbusesForMsgsCallback(
                            context,
                            actionInfo.getValue(),
                            actionInfo.getKey() == UserAction.SPAM,
                            TraceFutureCallback.wrap(multiCallback.newCallback(), context, "AbusesForMsgs_multi")),
                        context,
                        "AbusesForMsgs"));
            }
        }
        context.iexProxy().abusesGetRequestsStater();
        requestSettingsApi(TraceFutureCallback.wrap(multiCallback.newCallback(), context, "SettingsAPI_multi"));
        UserActionHandler.requestUserDayAbuses(
            context,
            TraceFutureCallback.wrap(
                new UserDayAbusesCallback(
                    context,
                    TraceFutureCallback.wrap(multiCallback.newCallback(), context, "UserDayAbuses_multi")),
                context,
                "UserDayAbuses"));
        for (final Map.Entry<String, Long> emailInfo : context.senderUids().entrySet()) {
            if (emailInfo.getValue() == 0L) {
                requestUserUid(
                    context,
                    TraceFutureCallback.wrap(multiCallback.newCallback(), context, "SenderInfo_multi"),
                    BlackBoxRequestType.SENDER,
                    emailInfo.getKey());
            }
        }
        for (final Map.Entry<String, Long> emailInfo : context.recipients().entrySet()) {
            if (emailInfo.getValue() == 0L) {
                requestUserUid(
                    context,
                    TraceFutureCallback.wrap(multiCallback.newCallback(), context, "RecipientInfo_multi"),
                    BlackBoxRequestType.RECIPIENT,
                    emailInfo.getKey());
            }
        }
    }

    @Override
    protected FutureCallback<JsonObject> sologCallback(
        final UserAction action,
        final List<Long> mids,
        final FutureCallback<Void> callback)
    {
        return TraceFutureCallback.wrap(
            new ComplSologInfoCallback(context, action, mids, callback),
            context,
            "ComplSologInfo");
    }

    @Override
    protected FutureCallback<String> sologgerCallback(
        final Map<List<String>, Long> queueIdMids,
        final FutureCallback<Void> callback)
    {
        return TraceFutureCallback.wrap(
            new CmplSologgerCollback(context, queueIdMids, callback),
            context,
            "CmplSologger");
    }

    public void requestSettingsApi(final FutureCallback<Void> callback) {
        IexProxy iexProxy = context.iexProxy();
        ImmutableURIConfig settingsConfig;
        AsyncClient client;
        String tvmTicket;
        if (context.corp()) {
            settingsConfig = iexProxy.config().corpSettingsApiConfig();
            client = iexProxy.corpSettingsApiClient();
            tvmTicket = context.iexProxy().corpSettingsApiTvm2Ticket();
        } else {
            settingsConfig = iexProxy.config().settingsApiConfig();
            client = iexProxy.settingsApiClient();
            tvmTicket = context.iexProxy().settingsApiTvm2Ticket();
        }
        try {
            QueryConstructor query = new QueryConstructor(
                new StringBuilder(settingsConfig.uri().toASCIIString()).append(settingsConfig.firstCgiSeparator()));
            query.append("uid", context.prefix());
            query.append("settings_list", "show_folders_tabs");
            String uri = query.toString();
            context.session().logger().info("Send Settings API request: " + uri);
            client.execute(
                new HeaderAsyncRequestProducerSupplier(
                    new AsyncGetURIRequestProducerSupplier(uri),
                    new BasicHeader(YandexHeaders.X_YA_SERVICE_TICKET, tvmTicket)),
                JsonAsyncTypesafeDomConsumerFactory.OK,
                context.session().listener().createContextGeneratorFor(client),
                new SettingApiCallback(context, callback));
        } catch (BadRequestException | URISyntaxException e) {
            context.session().logger().log(Level.SEVERE, "Settings API request building error", e);
            context.session().handleException(HttpExceptionConverter.toHttpException(e));
            callback.completed(null);
        }
    }

    private static class SettingApiCallback extends AbstractFilterFutureCallback<JsonObject, Void> {
        private final static String SHOW_FOLDERS_TABS = "show_folders_tabs";
        private final static String SINGLE_SETTINGS = "single_settings";
        private final AbstractUserActionContext context;

        public SettingApiCallback(final AbstractUserActionContext context, final FutureCallback<Void> callback) {
            super(callback);
            this.context = context;
        }

        @Override
        public void completed(final JsonObject result) {
            try {
                JsonMap params = result.asMap().getMap("settings").getMap("parameters");
                if (params.containsKey(SINGLE_SETTINGS)) {
                    JsonMap singleSettings = params.getMap(SINGLE_SETTINGS);
                    if (singleSettings != null && singleSettings.containsKey(SHOW_FOLDERS_TABS)) {
                        String value = singleSettings.get(SHOW_FOLDERS_TABS).asStringOrNull();
                        context.setShowTabs(value != null && !value.isEmpty() && BooleanParser.INSTANCE.apply(value));
                    } else {
                        context.setShowTabs(false);
                    }
                } else {
                    context.setShowTabs(false);
                }
            } catch (JsonException e) {
                context.session().logger().log(Level.SEVERE, "SettingApiCallback failed to parse response", e);
            }
            callback.completed(null);
        }

        @Override
        public void cancelled() {
            context.session().logger().warning(
                "SettingApiCallback request cancelled: " + context.session().listener().details());
            callback.completed(null);
        }

        @Override
        public void failed(final Exception e) {
            context.session().logger().log(Level.WARNING, "SettingApiCallback failed: "
                + context.session().listener().details() + " because of exception: " + e.toString(), e);
            callback.completed(null);
        }
    }

    private static class AbusesForMsgsCallback extends AbstractFilterFutureCallback<JsonObject, Void> {
        private final AbstractUserActionContext context;
        private final Map<String, Long> urlMids;

        public AbusesForMsgsCallback(
            final AbstractUserActionContext context,
            final List<Long> mids,
            final boolean isSpam,
            final FutureCallback<Void> callback)
        {
            super(callback);
            this.context = context;
            this.urlMids = new HashMap<>();
            for (final Long mid : mids) {
                final MailMessageContext msgContext = context.messages().get(mid).context();
                if (msgContext.stid() != null && !msgContext.stid().isEmpty()) {
                    urlMids.put(
                        UpdateDataExecutor.abusesUrl(
                            context.uid(),
                            msgContext.stid().replace(":", "\\:"),
                            isSpam ? "spam" : "ham"),
                            mid);
                }
            }
        }

        @Override
        public void completed(final JsonObject result) {
            try {
                JsonList hits = result.asMap().getList("hitsArray");
                for (final JsonObject hit : hits) {
                    JsonMap counters = hit.asMap();
                    String url = hit.get("url").asString();
                    if (urlMids.containsKey(url) && context.messages().containsKey(urlMids.get(url))) {
                        final MailMessageContext msgContext = context.messages().get(urlMids.get(url)).context();
                        //context.session().logger().info("AbusesForMsgCallback: abuses counters for uid="
                        //    + context.uid() + ": " + String.join(",", counters.keySet()));
                        msgContext.flags().add(Flags._XX);
                        msgContext.skipReasons().add(SkipReason.WAS);
                        long lastOperationDate = counters.getLong("abuses_last_timestamp");
                        if (msgContext.actionDate() <= lastOperationDate) {
                            msgContext.thisIsRetry();
                        }
                    }
                }
            } catch (JsonException e) {
                context.session().logger().log(Level.SEVERE, "AbusesForMsgCallback failed to parse response", e);
            }
            callback.completed(null);
        }

        @Override
        public void cancelled() {
            context.session().logger().warning(
                "AbusesForMsgCallback request cancelled: " + context.session().listener().details());
            callback.completed(null);
        }

        @Override
        public void failed(final Exception e) {
            context.session().logger().log(Level.WARNING, "AbusesForMsgCallback failed to find message abuses' info: "
                + context.session().listener().details() + " because of exception: ", e);
            callback.completed(null);
        }
    }

    private static class UserDayAbusesCallback extends AbstractFilterFutureCallback<JsonObject, Void> {
        private final AbstractUserActionContext context;

        public UserDayAbusesCallback(final AbstractUserActionContext context, final FutureCallback<Void> callback) {
            super(callback);
            this.context = context;
        }

        @Override
        public void completed(final JsonObject result) {
            try {
                JsonList hits = result.asMap().getList("hitsArray");
                if (hits != null
                        && hits.size() >= context.iexProxy().config().complaintsConfig().dailyComplaintsLimit()) {
                    for (final UpdateDataHolder doc : context.messages().values()) {
                        doc.context().skipReasons().add(SkipReason.MAXED);
                    }
                }
            } catch (JsonException e) {
                context.session().logger().log(Level.SEVERE, "UserDayAbusesCallback failed to parse response", e);
            }
            callback.completed(null);
        }

        @Override
        public void cancelled() {
            context.session().logger().warning(
                "UserDayAbusesCallback request cancelled: " + context.session().listener().details());
            callback.completed(null);
        }

        @Override
        public void failed(final Exception e) {
            context.session().logger().log(Level.WARNING, "UserDayAbusesCallback failed to find user abuses info: "
                + context.session().listener().details() + " because of exception: ", e);
            callback.completed(null);
        }
    }
}
