package ru.yandex.iex.proxy.complaints;

public enum ComplaintProcessingError {
    WrongDate("wrong-date"),
    NoTypes("NOTYPE"),
    DlvLogAbsent("dlvlog-absent"),
    ParsingDlvLogFailed("dlvlog-parsing-failed"),
    ParsingRulesFalied("bad-rules"),
    ParsingRcptUidFailed("rcpt-uid-unknown"),
    RcptLoginUnknown("rcpt-login-unknown"),
    ParsingQueueIdFailed("queueid-unknown"),
    ParsingMailBackendFailed("mailbackend-unknown"),
    ParsingGeoZoneFailed("geozone-unknown"),
    ParsingSoResFailed("so-resolution-unknown"),
    ParsingSenderIpFailed("sender-ip-unknown");

    private final String signalName;

    ComplaintProcessingError(final String signalName) {
        this.signalName = signalName;
    }

    public String signalName() {
        return signalName;
    }
}
