package ru.yandex.iex.proxy.complaints;

import java.io.File;
import java.util.Map;

import ru.yandex.client.so.shingler.config.ShinglerClientsConfig;
import ru.yandex.http.config.URIConfig;
import ru.yandex.logger.LoggerConfig;
import ru.yandex.stater.StaterConfig;

public interface ComplaintsConfig extends URIConfig {

    Map<Route, File> rulesDictFiles();

    Map<Route, Map<Integer, String>> rulesDictionaries();

    LoggerConfig complLog();

    LoggerConfig ytLog();

    StaterConfig complaintsLagStaterConfig();

    StaterConfig soSearchRequestsStaterConfig();

    int dailyComplaintsLimit();

    long messageExpirationPeriod();

    boolean shinglersDryRun();

    boolean shinglersAddStatByActions();

    ShinglerClientsConfig shinglersConfig();

    boolean useSologger();

    boolean useSolog();
}
