package ru.yandex.iex.proxy.complaints;

import java.io.File;
import java.util.Collections;
import java.util.Map;

import ru.yandex.client.so.shingler.config.ShinglerClientsConfig;
import ru.yandex.client.so.shingler.config.ShinglerClientsConfigDefaults;
import ru.yandex.http.config.URIConfigDefaults;
import ru.yandex.logger.LoggerConfig;
import ru.yandex.logger.MinimalLoggerConfigDefaults;
import ru.yandex.stater.StaterConfig;
import ru.yandex.stater.StaterConfigDefaults;

public class ComplaintsConfigDefaults extends URIConfigDefaults implements ComplaintsConfig {
    public static final ComplaintsConfigDefaults INSTANCE = new ComplaintsConfigDefaults();

    @Override
    public Map<Route, File> rulesDictFiles() {
        return Collections.emptyMap();
    }

    @Override
    public Map<Route, Map<Integer, String>> rulesDictionaries() {
        return Collections.emptyMap();
    }

    @Override
    public LoggerConfig complLog() {
        return MinimalLoggerConfigDefaults.INSTANCE;
    }

    @Override
    public LoggerConfig ytLog() {
        return MinimalLoggerConfigDefaults.INSTANCE;
    }

    @Override
    public  StaterConfig complaintsLagStaterConfig() {
        return StaterConfigDefaults.INSTANCE;
    }

    @Override
    public StaterConfig soSearchRequestsStaterConfig() {
        return StaterConfigDefaults.INSTANCE;
    }

    @Override
    public int dailyComplaintsLimit() {
        return 0;
    }

    @Override
    public long messageExpirationPeriod() {
        return 0L;
    }

    @Override
    public boolean shinglersDryRun() {
        return false;
    }

    @Override
    public boolean shinglersAddStatByActions() {
        return false;
    }

    @Override
    public ShinglerClientsConfig shinglersConfig() {
        return ShinglerClientsConfigDefaults.EMPTY;
    }

    @Override
    public boolean useSolog() {
        return true;
    }

    @Override
    public boolean useSologger() {
        return true;
    }
}
