package ru.yandex.iex.proxy.complaints;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.client.so.shingler.GeneralShingles;
import ru.yandex.client.so.shingler.SenderScheme;
import ru.yandex.client.so.shingler.SenderShingles;
import ru.yandex.client.so.shingler.ShingleException;
import ru.yandex.client.so.shingler.config.ShinglerType;
import ru.yandex.digest.Fnv;
import ru.yandex.iex.proxy.move.UpdateDataHolder;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;

public class DeleteProcessCallback extends UserActionProcessCallback {
    private static final String HASH = "hash";
    private static final String SENDERTYPE = "sendertype";

    public DeleteProcessCallback(
        final UserActionContext context,
        final FutureCallback<List<UpdateDataHolder>> callback)
    {
        super(context, callback);
    }

    @Override
    protected FutureCallback<JsonObject> sologCallback(
        final UserAction action,
        final List<Long> mids,
        final FutureCallback<Void> callback)
    {
        return TraceFutureCallback.wrap(
            new DeletesSologInfoCallback(context, action, mids, callback),
            context,
            "DeletesSologInfo");
    }

    @Override
    protected FutureCallback<String> sologgerCallback(
        final Map<List<String>, Long> queueIdMids,
        final FutureCallback<Void> callback)
    {
        return TraceFutureCallback.wrap(
            new DeleteSologgerCollback(context, queueIdMids, callback),
            context,
            "DeletesSologger");
    }

    private static void setUpSenderShingles(final AbstractUserActionContext context, final long mid) {
        final MailMessageContext msgContext = context.messages().get(mid).context();
        if (msgContext.seen() || msgContext.from() == null || msgContext.from().isEmpty()) {
            return;
        }
        SenderShingles shingles = new SenderShingles();
        try {
            final HashMap<String, Object> counters = new HashMap<>(Map.of(
                HASH, Fnv.fnv64(msgContext.from()),
                SENDERTYPE, 1,
                "read", 1,
                "deleted", 1
            ));
            if (msgContext.spfDkim() != null && msgContext.spfDkim()) {
                counters.put("dkim_del", 1);
            }
            shingles.loadCounters(
                new HashSet<>(Set.of(SenderScheme.SENDER_TOTALS, SenderScheme.SENDER_AD)),
                counters);
            if (msgContext.fromDomain() != null && !msgContext.fromDomain().isEmpty()) {
                counters.put(HASH, Fnv.fnv64(msgContext.fromDomain()));
                counters.put(SENDERTYPE, 2);
                shingles.loadCounters(
                    new HashSet<>(Set.of(SenderScheme.SENDER_TOTALS, SenderScheme.SENDER_AD)),
                    counters);
            }
            if (shingles.size() > 0 && shingles.get(GeneralShingles.SHINGLE).size() > 0) {
                msgContext.shinglersData().put(ShinglerType.SENDER, shingles);
            }
        } catch (ShingleException e) {
            context.session().logger().log(
                Level.SEVERE,
                "DeleteProcessCallback.setUpSenderShingles failed to set up shingles for sender-shingler",
                e);
        }
    }

    private static class DeletesSologInfoCallback extends SologInfoCallback {
        public DeletesSologInfoCallback(
            final AbstractUserActionContext context,
            final UserAction action,
            final List<Long> mids,
            final FutureCallback<Void> callback)
        {
            super(context, action, mids, callback);
        }

        @Override
        protected void processSologData(final String queueId, final JsonMap sologData) throws JsonException {
            super.processSologData(queueId, sologData);
            final Long mid = queueIdMids.get(queueId);
            context.messages().get(mid).context().fillFlags();
            setUpSenderShingles(context, mid);
        }
    }

    private static class DeleteSologgerCollback extends SologgerCallback {
        public DeleteSologgerCollback(
            final AbstractUserActionContext context,
            final Map<List<String>, Long> queueIdMids,
            final FutureCallback<Void> callback)
        {
            super(context, queueIdMids, callback);
        }

        @Override
        protected void processDeliveryLog(final String queueId, final Map<String, List<String>> headers) {
            try {
                super.processDeliveryLog(queueId, headers);
            } catch (Exception e) {
                context.session().logger().log(
                     Level.SEVERE,
                     "DeleteSologgerCollback.processDeliveryLog failed: " + e,
                     e);
            }
            setUpSenderShingles(context, queueIdMids.get(queueId));
        }
    }
}
