package ru.yandex.iex.proxy.complaints;

import java.util.List;
import java.util.Map;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.iex.proxy.AbstractCallback;
import ru.yandex.iex.proxy.AbstractContext;
import ru.yandex.iex.proxy.AbstractFilterSearchCallback;
import ru.yandex.iex.proxy.ChangeContext;
import ru.yandex.iex.proxy.IndexationContext;
import ru.yandex.iex.proxy.move.SingleMessageHeadersCallback;
import ru.yandex.iex.proxy.move.SingleMessageReporter;
import ru.yandex.iex.proxy.move.UpdateDataHolder;

import static ru.yandex.iex.proxy.move.MoveHandler.extractMids;

public class DeletesFilterSearchHandler extends AbstractFilterSearchCallback<UpdateDataHolder> {
    private static final String MID = "mid";

    private final List<Map<String, Object>> movedToTrash;

    public DeletesFilterSearchHandler(
        final AbstractContext context,
        final FutureCallback<List<UpdateDataHolder>> callback,
        final List<Map<String, Object>> movedToTrash)
    {
        super(context, callback, extractMids(movedToTrash));
        this.movedToTrash = movedToTrash;
    }

    @Override
    public boolean skipEmptyEntities() {
        return false;
    }

    @Override
    public AbstractCallback<UpdateDataHolder> subMessageCallback(IndexationContext<UpdateDataHolder> context) {
        return new SingleMessageReporter<>(context);
    }

    @Override
    public void executeSubCallback(AbstractCallback<UpdateDataHolder> callback) {
        Map<?, ?> actionInfo = null;
        final Long mid = Long.parseLong(callback.context().mid());
        for (final Map<?, ?> ai : movedToTrash) {
            if (ai.get(MID).equals(mid)) {
                actionInfo = ai;
                break;
            }
        }
        UserActionHandler.requestTikaite(
            context,
            "/headers",
            List.of("stid=" + callback.context().stid()),
            TraceFutureCallback.wrap(
                new SingleMessageHeadersCallback(
                    callback,
                    (ChangeContext) context,
                    callback.context(),
                    UserAction.DELETE,
                    actionInfo,
                    null),
                context,
                "SingleDelete"));
    }

    @Override
    public boolean skipSpam() {
        return false;
    }
}
