package ru.yandex.iex.proxy.complaints;

import java.util.Locale;

public enum Route {
    IN("in"),       // incoming mail
    OUT("out"),     // outgoing mail
    CORP("corp");   // corporative mail

    private final String lowerName;

    Route() {
        lowerName = name().toLowerCase(Locale.ROOT);
    }

    Route(final String lowerName) {
        this.lowerName = lowerName;
    }

    public String lowerName() {
        return lowerName;
    }
}
