package ru.yandex.iex.proxy.complaints;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpStatus;
import org.apache.http.nio.protocol.BasicAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.proxy.BasicProxySession;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.iex.proxy.IexProxy;
import ru.yandex.parser.config.ConfigException;

public class RulesDictUpdateHandler implements HttpAsyncRequestHandler<HttpRequest> {
    protected final IexProxy iexProxy;

    public RulesDictUpdateHandler(final IexProxy iexProxy) {
        this.iexProxy = iexProxy;
    }

    public IexProxy iexProxy() {
        return iexProxy;
    }

    @Override
    public BasicAsyncRequestConsumer processRequest(
        final HttpRequest request,
        final HttpContext context)
    {
        return new BasicAsyncRequestConsumer();
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpAsyncExchange exchange,
        final HttpContext context)
        throws HttpException, IOException
    {
        handle(new BasicProxySession(iexProxy, exchange, context));
    }

    private void handle(final ProxySession session) throws HttpException
    {
        final Logger logger = session.logger();
        try {
            iexProxy.config().complaintsConfig().reloadRulesDictionaries();
        } catch (ConfigException e) {
            logger.log(Level.WARNING, "RulesDictUpdateHandler: Rules dictionaries reloading failed", e);
        }
        StringBuilder sb = new StringBuilder();
        if (iexProxy.config().complaintsConfig().rulesDictionaries() != null) {
            for (Route route : Route.values()) {
                if (iexProxy.config().complaintsConfig().rulesDictionaries().containsKey(route)) {
                    sb.append(sb.toString().isBlank() ? "" : ", ").append(route.name()).append(": ")
                        .append(iexProxy.config().complaintsConfig().rulesDictionaries().get(route).size());
                }
            }
        }
        logger.info(
            "RulesDictUpdateHandler: Rules dictionaries reloading completed. Loaded rules count: " + sb + '.');
        session.response(HttpStatus.SC_OK);
    }
}
