package ru.yandex.iex.proxy.complaints;

import java.util.Locale;

public enum SkipReason {
    WAS,            // this complaint is repeated
    FAKE_FOO,       // complaint on spam on spam-letter or on ham on ham-letter
    MAXED,          // user exceeded daily limit of complaints
    ON_OWN_LETTERS, // users complaint on own letter
    FBL_EXT,        // FBL-report on spam-letter from user which is not Yandex-related (uid does not exist)
    OLDER_30_DAYS,  // complaint on old letter (message date exceeded 30 days)
    TEST_LETTER,    // system detected that this complaint is complaint on test-letter (in testing purposes)
    IMAP,           // IMAP action
    AUTOMATION;     // action by automation

    private final String lowerName;

    SkipReason() {
        lowerName = name().toLowerCase(Locale.ROOT);
    }

    public String lowerName() {
        return lowerName;
    }
}
