package ru.yandex.iex.proxy.complaints;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.util.IdempotentFutureCallback;
import ru.yandex.iex.proxy.AbstractHandlersContext;
import ru.yandex.logger.PrefixedLogger;

public class TraceFutureCallback<T> extends IdempotentFutureCallback<T> {
    private final PrefixedLogger logger;
    private final String prompt;

    public TraceFutureCallback(
        final FutureCallback<? super T> callback,
        final PrefixedLogger logger,
        final String prompt)
    {
        super(callback);
        this.logger = logger;
        this.prompt = prompt;
    }

    @SuppressWarnings("deprecation")
    @Override
    protected void finalize() throws Throwable {
        try {
            if (!completed.get()) {
                logger.warning("You forget to execute '" + callback.toString() + "'!"
                    + (prompt == null ? "" : (" (" + prompt + ")")));
            }
        } finally {
            super.finalize();
        }
    }

    public static <T> FutureCallback<T> wrap(
        final FutureCallback<T> callback,
        final AbstractHandlersContext context,
        final String prompt)
    {
        if (context.session().debugFlags().contains("wrap-callbacks")) {
            return new TraceFutureCallback<>(callback, context.session().logger(), prompt);
        }
        return callback;
    }
}
