package ru.yandex.iex.proxy.config;

import ru.yandex.http.config.AbstractURIConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractSmartObjectConfigBuilder
    <T extends AbstractSmartObjectConfigBuilder<T>>
     extends AbstractURIConfigBuilder<T>
     implements SmartObjectConfig
{
    private double passPercent;

    protected AbstractSmartObjectConfigBuilder(final SmartObjectConfig config) {
        super(config);
        passPercent(config.passPercent());
    }

    protected AbstractSmartObjectConfigBuilder(
        final IniConfig config,
        final SmartObjectConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        this.passPercent =
            config.getDouble("pass-percent", defaults.passPercent());
    }

    @Override()
    public double passPercent() {
        return passPercent;
    }

    public T passPercent(final double value) {
        this.passPercent = value;
        return self();
    }
}
