package ru.yandex.iex.proxy.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class SmartObjectConfigBuilder
     extends AbstractSmartObjectConfigBuilder<SmartObjectConfigBuilder>
{
    public SmartObjectConfigBuilder() {
        this(SmartObjectConfigDefaults.INSTANCE);
    }

    public SmartObjectConfigBuilder(final SmartObjectConfig config) {
        super(config);
    }

    public SmartObjectConfigBuilder(
        final IniConfig config)
        throws ConfigException
    {
        this(config, SmartObjectConfigDefaults.INSTANCE);
    }

    public SmartObjectConfigBuilder(
        final IniConfig config,
        final SmartObjectConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    public ImmutableSmartObjectConfig build() throws ConfigException {
        return new ImmutableSmartObjectConfig(
            this);
    }

    @Override
    public SmartObjectConfigBuilder self() {
        return this;
    }
}
