package ru.yandex.iex.proxy.cvhandler;

import java.util.HashMap;
import java.util.Map;

import org.apache.http.HttpException;
import org.apache.http.HttpStatus;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.iex.proxy.AbstractEntityContext;
import ru.yandex.iex.proxy.IexProxy;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;

public class CvContext extends AbstractEntityContext {
    private Map<?, ?> input = null;
    private Map<String, Object> cvs = new HashMap<>();
    private int cvIndex = 0;

    CvContext(
        final IexProxy iexProxy,
        final ProxySession session,
        final Map<?, ?> json)
        throws HttpException, JsonUnexpectedTokenException
    {
        super(iexProxy, session, json);
        input = json;
    }

    public Map<?, ?> getInput() {
        return input;
    }

    public void addCv(final Object cv) {
        cvs.put("cv_" + cvIndex, cv);
        ++cvIndex;
    }

    @Override
    public void response() {
        session.response(
            HttpStatus.SC_OK,
            JsonType.NORMAL.toString(cvs));
    }
}
