package ru.yandex.iex.proxy.cvhandler;

import java.util.Map;

import org.apache.http.HttpException;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.iex.proxy.AbstractEntityHandler;
import ru.yandex.iex.proxy.IexProxy;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;

public class CvHandler extends AbstractEntityHandler<CvContext> {
    public static final String CV_RESUME = "cv_resume";
    private static final int MAX_CV_SV = 100;

    public CvHandler(final IexProxy iexProxy) {
        super(iexProxy, "cv");
    }

    @Override
    protected CvContext createContext(
        final IexProxy iexProxy,
        final ProxySession session,
        final Map<?, ?> json)
        throws HttpException, JsonUnexpectedTokenException
    {
        return new CvContext(iexProxy, session, json);
    }

    @Override
    protected void handle(final CvContext context)
        throws JsonUnexpectedTokenException, BadRequestException
    {
        Map<?, ?> in = context.getInput();
        if (in != null) {
            put(CV_RESUME, context, in);
            for (int i = 1; i < MAX_CV_SV; ++i) {
                if (!put(CV_RESUME + '_' + String.valueOf(i), context, in)) {
                    break;
                }
            }
        }
        context.response();
    }

    private boolean put(
        final String key,
        final CvContext context,
        final Map<?, ?> in)
    {
        if (in.containsKey(key)) {
            context.addCv(in.get(key));
            return true;
        } else {
            return false;
        }
    }
}
