package ru.yandex.iex.proxy.edahandler;

import java.util.List;
import java.util.Map;

import org.apache.http.HttpException;
import org.apache.http.HttpStatus;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.iex.proxy.AbstractEntityContext;
import ru.yandex.iex.proxy.IexProxy;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;
import ru.yandex.json.xpath.ValueUtils;

public class EdaContext extends AbstractEntityContext {
    public static final String EDA = "eda";
    public static final String FISCAL_OOO = "fiscal_ooo";
    protected Map<?, ?> edaResponse;

    public EdaContext(
        final IexProxy iexProxy,
        final ProxySession session,
        final Map<?, ?> json)
        throws HttpException, JsonUnexpectedTokenException
    {
        super(iexProxy, session, json);
        edaResponse = null;
        if (json != null && json.get(EDA) != null) {
            List<?> listEda = ValueUtils.asList(json.get(EDA));
            int maxResponseSize = 0;
            for (Object response : listEda) {
                int responseSize = ((Map<?, ?>) response).size();
                if (responseSize > maxResponseSize) {
                    edaResponse = ValueUtils.asMap(response);
                    maxResponseSize = responseSize;
                }
            }
            // hardcode for TAXIANALYTICS-4827
            // ignore fiscal solutions in all cases except Delivery Club
            if (getDomain().equals("corp.mail.ru")) {
                if (!edaResponse.containsKey(FISCAL_OOO)) {
                    edaResponse = null;
                } else if (!edaResponse.get(FISCAL_OOO).
                    equals("Деливери Клаб"))
                {
                    edaResponse = null;
                }
            }
            // hardcode for IEX-2512, do not send 'cart' to main YT table
            if (edaResponse != null && edaResponse.containsKey("cart")) {
                processCart();
            }
        }
    }

    protected void processCart() {
        edaResponse.remove("cart");
        if (edaResponse.containsKey("rest_name")) {
            edaResponse.remove("rest_name");
        }
    }

    @Override
    public void response() {
        session.response(
            HttpStatus.SC_OK,
            JsonType.NORMAL.toString(edaResponse));
    }
}
