package ru.yandex.iex.proxy.edahandler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.http.HttpException;
import org.apache.http.HttpStatus;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.iex.proxy.IexProxy;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;

public class EdaExtendedContext extends EdaContext {
    public static final String XPATH_LIST_DELIMITER ="\\|\\s+\\|";
    protected Map<String, Object> edaWithCartResponse;

    public EdaExtendedContext(
        final IexProxy iexProxy,
        final ProxySession session,
        final Map<?, ?> json)
        throws HttpException, JsonUnexpectedTokenException
    {
        super(iexProxy, session, json);
    }

    @Override
    protected void processCart() {
        edaWithCartResponse = new HashMap<>();
        String[] cartListStrings = edaResponse.get("cart").toString().replaceAll("\u00a0","").split(XPATH_LIST_DELIMITER);
        for (Map.Entry<?, ?> entry : edaResponse.entrySet()) {
            edaWithCartResponse.put(entry.getKey().toString(), entry.getValue().toString());
        }
        List<Map<String,String>> cartWithInns = new ArrayList<>();
        List<Map<String,String>> cart = new ArrayList<>();
        boolean debugCart = false;
        Set<String> inns = new HashSet<>();
        Map<String, String> cartWithInnItem = new HashMap<>();
        Map<String, String> cartItem = new HashMap<>();
        Pattern nameAndPrice = Pattern.compile(
            "^(.*)\\s+([0-9]+)\\s*[X|×]\\s*([0-9\\.]+).*");
        Pattern discountBeforeName = Pattern.compile("^(Discount\\s*[0-9]+\\%|Скидка\\s*[0-9]+\\%)(.*)");
        Pattern restPattern = Pattern.compile(".*наименование поставщика\\s+(.*)\\s+ИНН поставщика\\s+([0-9]+)");
        Pattern onlyInnPattern = Pattern.compile(".*ИНН поставщика\\s+([0-9]+)");
        for (String cartString : cartListStrings) {
            String trimmedValue = cartString.replaceAll("\\|", "").trim();
            Matcher mNameAndPrice = nameAndPrice.matcher(trimmedValue);
            Matcher mSupplier = restPattern.matcher(trimmedValue);
            Matcher mInn = onlyInnPattern.matcher(trimmedValue);
            if (mNameAndPrice.find()) {
                String discountAndName = mNameAndPrice.group(1).trim();
                if (discountAndName.startsWith("Скидка") || discountAndName.startsWith("Discount")) {
                    Matcher mDiscount = discountBeforeName.matcher(discountAndName);
                    if (mDiscount.find()) {
                        cartWithInnItem.put("discount", mDiscount.group(1).trim());
                        cartWithInnItem.put("name", mDiscount.group(2).trim());
                    }
                } else {
                    cartWithInnItem.put("name", mNameAndPrice.group(1).trim());
                }
                cartWithInnItem.put("amount", mNameAndPrice.group(2).trim());
                cartWithInnItem.put("cost", mNameAndPrice.group(3).trim());
                cartItem.put("name", mNameAndPrice.group(1).trim());
                cartItem.put("amount", mNameAndPrice.group(2).trim());
                cartItem.put("cost", mNameAndPrice.group(3).trim());
                cart.add(cartItem);
                cartItem = new HashMap<>();
            } else if (mSupplier.find()) {
                cartWithInnItem.put("rest_name", mSupplier.group(1).trim());
                String inn = mSupplier.group(2).trim();
                cartWithInnItem.put("inn", inn);
                inns.add(inn);
                cartWithInns.add(cartWithInnItem);
                cartWithInnItem = new HashMap<>();
            } else if (mInn.find()) {
                String inn = mInn.group(1).trim();
                cartWithInnItem.put("inn", inn);
                inns.add(inn);
                cartWithInns.add(cartWithInnItem);
                cartWithInnItem = new HashMap<>();
            } else {
                if (!trimmedValue.contains("Деливери Клаб")
                    && !trimmedValue.contains("Данные поставщика")) {
                        debugCart = true;
                }
            }
        }
        edaWithCartResponse.put("cart_with_inns", cartWithInns);
        edaWithCartResponse.put("cart", cart);
        boolean uniqProvider = (inns.size() == 1);
        edaWithCartResponse.put("uniq_provider", uniqProvider);
        if (debugCart) {
            edaWithCartResponse.put("debug_cart", edaResponse.get("cart"));
        }
    }

    @Override
    public void response() {
        session.response(
            HttpStatus.SC_OK,
            JsonType.NORMAL.toString(edaWithCartResponse));
    }
}
