package ru.yandex.iex.proxy.edahandler;

import java.util.Map;

import org.apache.http.HttpException;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.iex.proxy.AbstractEntityHandler;
import ru.yandex.iex.proxy.IexProxy;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;

public class EdaExtendedHandler extends AbstractEntityHandler<EdaExtendedContext> {
    public EdaExtendedHandler(final IexProxy iexProxy) {
        super(iexProxy);
    }

    @Override
    protected EdaExtendedContext createContext(
            final IexProxy iexProxy,
            final ProxySession session,
            final Map<?, ?> json)
        throws HttpException, JsonUnexpectedTokenException
    {
        return new EdaExtendedContext(iexProxy, session, json);
    }

    @Override
    protected void handle(final EdaExtendedContext context)
        throws JsonUnexpectedTokenException, BadRequestException
    {
        context.response();
    }
}
