package ru.yandex.iex.proxy.eshophandler;

import java.util.HashMap;
import java.util.Map;

import org.apache.http.HttpException;
import org.apache.http.HttpStatus;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.iex.proxy.AbstractEntityContext;
import ru.yandex.iex.proxy.IexProxy;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;

public class EshopContext extends AbstractEntityContext {
    private EshopStructureMaker structMaker = new EshopStructureMaker();
    private HashMap<String, Object> result = new HashMap<>();
    private String orderNumber;

    EshopContext(
        final IexProxy iexProxy,
        final ProxySession session,
        final Map<?, ?> json)
        throws HttpException, JsonUnexpectedTokenException
    {
        super(iexProxy, session, json);
        String subject = session.params().getOrNull("subject");
        result = structMaker.make(json, subject);
        orderNumber = structMaker.getOrderNumber();
    }

    @Override
    public void response() {
        session.response(HttpStatus.SC_OK, JsonType.NORMAL.toString(result));
    }

    public void addMarketInfo(final Object marketData) {
        result.put("order_items", marketData);
    }

    public void addYuids(final Object yuids) {
        result.put("yuids", yuids);
    }

    public void addIsNewOrder(final String isNewOrder) {
        result.put("is_new_order", isNewOrder);
    }

    public Map<String, Object> getResult() {
        return result;
    }

    public String getOrderNumber() {
        return orderNumber;
    }
}
