package ru.yandex.iex.proxy.eshophandler;

import java.util.List;

import org.apache.http.HttpHost;

import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.iex.proxy.GenerateLuceneRequestHelper;
import ru.yandex.iex.proxy.cacheupdate.CacheModificationSettingsDefaults;
import ru.yandex.parser.uri.QueryConstructor;
import ru.yandex.search.proxy.SearchResultConsumerFactory;
import ru.yandex.search.result.SearchResult;

public class EshopHostsCallback
    extends AbstractProxySessionCallback<List<HttpHost>>
{
    private static final String TRUE = "true";
    private static final String LOG_PREFIX = "EshopHostsCalback: ";
    private EshopContext context;
    private AbstractProxySessionCallback<SearchResult> callback;

    public EshopHostsCallback(
        final EshopContext context,
        final AbstractProxySessionCallback<SearchResult> callback)
    {
        super(context.session());
        this.context = context;
        this.callback = callback;
    }

    @Override
    public synchronized void completed(final List<HttpHost> hosts) {
        context.session().logger().
            info(LOG_PREFIX + "list of hosts, size = " + hosts.size());
        AsyncClient searchClient = context.iexProxy().searchClient()
            .adjust(context.session().context());
        try {
            for (HttpHost host : hosts) {
                context.session().logger().
                    info(LOG_PREFIX + "host: " + host.toHostString());
            }

            QueryConstructor query = new QueryConstructor(
                GenerateLuceneRequestHelper.getLuceneRequestPrefix()
                + context.uid());
            query.append(
                "service",
                context.iexProxy().config().factsIndexingQueueName());

            String requestText = GenerateLuceneRequestHelper.
                generateRequestText(
                    "eshop",
                    "order_number",
                    context.getOrderNumber(),
                    context.getReceivedDate(),
                    CacheModificationSettingsDefaults.ESHOP_UPDATE_AGE_LIMIT);
            GenerateLuceneRequestHelper.query(
                    query,
                    context.getOrderNumber(),
                    requestText,
                    "fact_data,fact_domain",
                    CacheModificationSettingsDefaults.ESHOP_UPDATE_DEPTH);

            context.session().logger().
                info(LOG_PREFIX + "query string = " + query.toString());
            searchClient.execute(
                hosts,
                new BasicAsyncRequestProducerGenerator(query.toString()),
                SearchResultConsumerFactory.OK,
                context.session().listener()
                    .createContextGeneratorFor(searchClient),
                callback);
        } catch (BadRequestException e) {
            context.session().logger().
                info(LOG_PREFIX + "BadRequestException in EshopHostsCallback");
            e.printStackTrace();
        }
    }
}
