package ru.yandex.iex.proxy.eshophandler;

/*
OrderConfirmation подтвержден
OrderPaid оплачен
OrderProcessing в обработке
OrderCancelled отменен
OrderDelivered доставлен
OrderInTransit доставляется
OrderPaymentDue ждет оплаты
OrderPickupAvailable готов к выдаче
OrderReturned возвращен
OrderProblem representing that there is a problem with the order.
 */

import java.util.Locale;

public final class StatusDefinition { // TODO: use regexp
    private static final String HTTP_SCHEMA_ORG = "http://schema.org/";
    private static final String[] ORDER_CONFIRMATION_MSG =
        {
        "cпасибо за оформление заказа",
        "одтверждение заказа",
        "сформирован",
        "принят",
        "Order Confirmation",
        "подтвержден",
        "Новый заказ",
        "ас за оформленный заказ",
        "заказ создан",
        "Спасибо за ваш заказ",
        "Вы оформили заказ",
        "Благодарим вас за оформленный заказ",
        "успешно зарегистрирован",
        "оформлен в",
        "Ваш заказ оформлен",
        "получили",
        "заказ принят",
        "предзаказ принят",
        "Вы заказали"
        };
    private static final String[] ORDER_PAID =
        {
        "Платёж совершён",
        "платеж совершен",
        "предоплата поступила на счет"
        };
    private static final String[] ORDER_PROCESSING =
        {
        "представитель получил заказ",
        "исполняется",
        "обрабатывается",
        "поступил в обработку",
        "проверяется",
        "пока не обработала",
        "передан на комплектацию",
        "передан на исполнение",
        "Информация по вашему заказу",
        };
    private static final String[] ORDER_CANCELLED =
        {
        "отмен",
        "вы аннулировали заказ",
        "срок резерва по заказу истёк"
        };
    private static final String[] ORDER_DELIVERED =
        {
        "выдан",
        "заказ доставлен",
        "доставлен в магазин",
        "прибыл в пункт самовывоза"
        };
    private static final String[] ORDER_TRANSIT =
        {
        "отправил",
        "передан в службу доставки",
        "заказ в пути",
        "будем информировать вас о ходе доставки по СМС и электронной почте",
        "отправлен",
        };
    private static final String[] ORDER_PAYMENT_DUE =
        {
        "жду оплаты",
        "для оплаты заказа на вашем счету была зарезервирована сумма"
        };
    private static final String[] ORDER_PICKUP_AVAILABLE =
        {
        "товар готов к выдаче",
        "ждет вас",
        "готов к выдаче",
        "встречайте заказ",
        "заказ прибыл в пункт самовывоза",
        "можно забрать"
        };
    private static final String[] ORDER_RETURNED =
        {
        "Просрочено",
        "товар возвращен"
        };
    private static final String[] ORDER_PROBLEM =
        {
        "закончилась на нашем складе",
        "нему хотите отменить заказ",
        "подходит к концу"
        };

    private StatusDefinition() {
    }

    public static String getShortStatus(final String rawStatusOrder) {
        String finalStatus = rawStatusOrder;
        String rawStatus = rawStatusOrder.toLowerCase(Locale.getDefault());
        if (isTextContainsOneOf(rawStatus, ORDER_CONFIRMATION_MSG)) {
            finalStatus = "OrderConfirmation";
        } else if (isTextContainsOneOf(rawStatus, ORDER_PROCESSING)) {
            finalStatus = "OrderProcessing";
        } else if (isTextContainsOneOf(rawStatus, ORDER_DELIVERED)) {
            finalStatus = "OrderDelivered";
        } else if (isTextContainsOneOf(rawStatus, ORDER_CANCELLED)) {
            finalStatus = "OrderCancelled";
        } else if (isTextContainsOneOf(rawStatus, ORDER_TRANSIT)) {
            finalStatus = "OrderInTransit";
        } else if (isTextContainsOneOf(rawStatus, ORDER_PROBLEM)) {
            finalStatus = "OrderProblem";
        } else if (isTextContainsOneOf(rawStatus, ORDER_PAID)) {
            finalStatus = "OrderPaid";
        } else if (isTextContainsOneOf(rawStatus, ORDER_RETURNED)) {
            finalStatus = "OrderReturned";
        } else if (isTextContainsOneOf(rawStatus, ORDER_PAYMENT_DUE)) {
            finalStatus = "OrderPaymentDue";
        } else if (isTextContainsOneOf(rawStatus, ORDER_PICKUP_AVAILABLE)) {
            finalStatus = "OrderPickupAvailable";
        } else if (finalStatus.contains(HTTP_SCHEMA_ORG)) {
            finalStatus = finalStatus.replace(HTTP_SCHEMA_ORG, "");
        } else {
            finalStatus = "";
        }
        return finalStatus;
    }

    private static boolean isTextContainsOneOf(
        final String text,
        final String[] array)
    {
        for (String x : array) {
            if (text.contains(x.toLowerCase(Locale.getDefault()))) {
                return true;
            }
        }
        return false;
    }
}
