package ru.yandex.iex.proxy.eventtickethandler;

import org.apache.http.concurrent.FutureCallback;

public abstract class EventCallback implements FutureCallback<Object> {
    protected EventTicketContext context;
    protected EventCallback callback = null;

    public EventCallback(final EventCallback callback) {
        this.callback = callback;
    }

    public EventCallback() {
    }

    @Override
    public void cancelled() {
        if (callback != null) {
            callback.execute(context);
        }
    }

    @Override
    public void failed(final Exception e) {
        if (callback != null) {
            callback.execute(context);
        }
    }

    @Override
    public void completed(final Object result) {
        if (callback != null) {
            callback.execute(context);
        }
    }

    public abstract void act(final EventTicketContext context);

    public void execute(final EventTicketContext context) {
        this.context = context;
        act(context);
        completed(null);
    }
}
