package ru.yandex.iex.proxy.eventtickethandler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import ru.yandex.iex.proxy.XRegexpUtils;

public abstract class EventParser {
    public abstract void parse(
        final Object in,
        final Map<String, Object> out);

    protected ArrayList<String> parseRowsByRegexp(final String s) {
        return XRegexpUtils.getRows(s);
    }

    protected ArrayList<String> parseHallsByRegexp(final String s) {
        return XRegexpUtils.getHalls(s);
    }

    protected ArrayList<String> parseSeatsByRegexp(final String s) {
        return XRegexpUtils.getSeats(s);
    }

    protected List<Map<String, Object>> parseSeatsStructure(
        final String s)
    {
        ArrayList<String> rows = parseRowsByRegexp(s);
        ArrayList<Integer> irows = new ArrayList<>();
        for (final String x : rows) {
            final List<Integer> tmp = XRegexpUtils.getInts(x);
            for (Integer rx : tmp) {
                irows.add(rx);
            }
        }
        ArrayList<String> halls = parseHallsByRegexp(s);
        ArrayList<Integer> ihalls = new ArrayList<>();
        for (final String x : halls) {
            final List<Integer> tmp = XRegexpUtils.getInts(x);
            for (Integer hx : tmp) {
                ihalls.add(hx);
            }
        }
        ArrayList<String> seats = parseSeatsByRegexp(s);
        ArrayList<Integer> iseats = new ArrayList<>();
        for (final String x : seats) {
            final List<Integer> tmp = XRegexpUtils.getInts(x);
            for (Integer hx : tmp) {
                iseats.add(hx);
            }
        }
        int sz = iseats.size();
        int rz = irows.size();
        int hz = ihalls.size();
        List<Map<String, Object>> seatsStructured = new ArrayList<>();
        for (int i = 0; i < sz; i++) {
            int tmpRow = -1;
            if (rz > 0) {
                tmpRow = irows.get(i % rz);
            }
            int tmpHall = -1;
            if (hz > 0) {
                tmpHall = ihalls.get(i % hz);
            }
            Map<String, Object> st = new HashMap<>();
            if (tmpRow != -1) {
                st.put(EventTicketHandler.ROW, tmpRow);
            }
            if (tmpHall != -1) {
                st.put(EventTicketHandler.HALL, tmpHall);
            }
            st.put("seat", iseats.get(i));
            seatsStructured.add(st);
        }
        return seatsStructured;
    }
}
