package ru.yandex.iex.proxy.eventtickethandler;

import java.util.HashMap;
import java.util.Map;

import org.apache.http.HttpException;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.YandexHttpStatus;
import ru.yandex.iex.proxy.AbstractEntityContext;
import ru.yandex.iex.proxy.IexProxy;
import ru.yandex.iex.proxy.IndexationContext;
import ru.yandex.iex.proxy.XJsonUtils;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;

public class EventTicketContext extends AbstractEntityContext {
    private Map<String, Object> jsonInput = new HashMap<>();
    private Map<String, Object> jsonOutput = new HashMap<>();
    private String domain;
    private String stid;

    public EventTicketContext(
        final IexProxy iexProxy,
        final ProxySession session,
        final Map<?, ?> json)
        throws HttpException, JsonUnexpectedTokenException
    {
        super(iexProxy, session, json);
        session.logger().info("creating EventTicketContext with json = "
                + JsonType.NORMAL.toString(json));
        try {
            domain =
                IndexationContext.extractDomain(
                    session.params().getString("email"));
            XJsonUtils.putAll(json, jsonInput);
            stid = session.params().getOrNull("stid");
        } catch (JsonUnexpectedTokenException e) {
        } catch (BadRequestException e) {
        }
    }

    public Map<String, Object> getInputJson() {
        return jsonInput;
    }

    public Map<String, Object> getOutputJson() {
        return jsonOutput;
    }

    public void setNewSolution(final Map<String, Object> sol) {
        jsonOutput = sol;
    }

    public String getDomain() {
        return domain;
    }

    public String getStid() {
        return stid;
    }

    @Override
    public void response() {
        session.response(
            YandexHttpStatus.SC_OK,
            JsonType.NORMAL.toString(jsonOutput));
    }

    public void log(final String str) {
        session.logger().info(str);
    }
}
