package ru.yandex.iex.proxy.eventtickethandler;

import java.util.Map;

import org.apache.http.HttpException;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.iex.proxy.AbstractEntityHandler;
import ru.yandex.iex.proxy.IexProxy;
import ru.yandex.iex.proxy.MicroEventCallback;
import ru.yandex.iex.proxy.PdfGetHidsCallback;
import ru.yandex.iex.proxy.PkpassAttachCallback;
import ru.yandex.iex.proxy.afisha.AfishaCallback;
import ru.yandex.iex.proxy.calendar.CalendarEventCallback;
import ru.yandex.iex.proxy.kinopoisk.KinopoiskQlCallback;
import ru.yandex.iex.proxy.mboeventticketextractor.MboExtractByDomainCallback;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;

public class EventTicketHandler
    extends AbstractEntityHandler<EventTicketContext>
{
    public static final String ORIGIN = "origin";
    public static final String WIDGET_SUBTYPE = "widget_subtype";
    public static final String DOMAIN = "domain";
    public static final String IEX_MSG = "iex_msg";
    public static final String RAW_DATA = "raw_data";
    public static final String SPECIAL_PARTS = "special_parts";
    public static final String PRINT_PARTS = "print_parts";
    public static final String CINEMA = "cinema";
    public static final String TITLE = "title";
    public static final String SEATS = "seats";
    public static final String ROW = "row";
    public static final String HALL = "hall";
    public static final String LOCATION = "location";
    public static final String NAME = "name";
    public static final String MOVIE = "movie";
    public static final String CITY = "city";
    public static final String START_DATE = "start_date";
    public static final String DATA = "data";
    public static final String START_DATE_TS = "start_date_ts";
    public static final String DESCRIPTION = "description";
    public static final String HID = "hid";
    public static final String UID = "uid";
    public static final String STID = "stid";
    public static final String LANG = "lang";

    public EventTicketHandler(final IexProxy iexProxy) {
        super(iexProxy, "event-ticket");
    }

    @Override
    protected EventTicketContext createContext(
        final IexProxy iexProxy,
        final ProxySession session,
        final Map<?, ?> json)
        throws HttpException, JsonUnexpectedTokenException
    {
        return new EventTicketContext(iexProxy, session, json);
    }

    @Override
    protected void handle(final EventTicketContext context) {
        EventCallback headCallback =
            new MicroEventCallback(
                new PkpassAttachCallback(
                    new CalendarEventCallback(
                        new MboExtractByDomainCallback(
                            new PdfGetHidsCallback(
                                new KinopoiskQlCallback(
                                    new AfishaCallback(
                                        new EndCallback())))))));
        headCallback.execute(context);
    }

    private static class EndCallback extends EventCallback {
        @Override
        public void execute(final EventTicketContext context) {
            context.response();
        }

        @Override
        public void act(final EventTicketContext context) {
            // not implemented
        }
    }
}
