package ru.yandex.iex.proxy.eventtickethandler;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

import org.apache.http.HttpException;
import org.apache.http.HttpStatus;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.iex.proxy.AbstractEntityContext;
import ru.yandex.iex.proxy.CinemaInfoParser;
import ru.yandex.iex.proxy.IexProxy;
import ru.yandex.iex.proxy.IndexationContext;
import ru.yandex.iex.proxy.XJsonUtils;
import ru.yandex.json.dom.JsonString;
import ru.yandex.json.dom.TypesafeValueContentHandler;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;
import ru.yandex.json.xpath.ValueUtils;

public class PkpassContext extends AbstractEntityContext {
    // Nowadays PkpassContext only for test CinemaInfoParser-class is used
    public static final String PKPASS = "pkpass";
    public static final String WIDGET_SUBTYPE = "widget_subtype";
    public static final String DOMAIN = "domain";
    public static final String UNKNOWN = "unknown";
    public static final String MICRO = "micro";
    public static final String TYPE = "@type";
    private Object pkpassZip;
    private String domain;
    private String origin = UNKNOWN;
    private EventParser cinemaParser = new CinemaInfoParser();

    public PkpassContext(
        final IexProxy iexProxy,
        final ProxySession session,
        final Map<?, ?> json)
        throws HttpException, JsonUnexpectedTokenException
    {
        super(iexProxy, session, json);
        try {
            pkpassZip =
                XJsonUtils.getNodeByPathOrNull(json, PKPASS, "getbody", "text");
            if (pkpassZip instanceof String) {
                origin = PKPASS;
                try {
                    pkpassZip =
                        TypesafeValueContentHandler.parse(
                            (String) pkpassZip).asMap();
                } catch (JsonException e) {
                    pkpassZip = null;
                }
            }

            if (pkpassZip == null) {
                pkpassZip = XJsonUtils.getNodeByPathOrNull(
                    json,
                    MICRO,
                    UNKNOWN);
                if (!isEventReservation(pkpassZip)) {
                    pkpassZip = null;
                }
                if (pkpassZip != null) {
                    origin = MICRO;
                }
            }

            if (pkpassZip != null && pkpassZip instanceof Map) {
                domain = asString(session.params().getString("email"));
                HashMap<String, Object> pkpassSolution = new HashMap<>();
                cinemaParser.parse(
                    pkpassZip,
                    pkpassSolution);
                pkpassSolution.put(WIDGET_SUBTYPE, "cinema");
                pkpassSolution.put("origin", origin);
                pkpassSolution.put(
                    DOMAIN,
                    IndexationContext.extractDomain(domain));
                Map<String, Object> rawDatalikeInTest = new HashMap<>();
                rawDatalikeInTest.put("type", origin);
                rawDatalikeInTest.put("data", pkpassZip);
                final Object hid =
                    XJsonUtils.getNodeByPathOrNull(json, PKPASS, "hid_pkpass");
                if (hid != null) {
                    pkpassSolution.put("special_parts", Arrays.asList(hid));
                }
                pkpassSolution.put("raw_data", rawDatalikeInTest);
                pkpassZip = pkpassSolution;
            }
        } catch (NullPointerException e) {
            throw new BadRequestException("NPE happened when pkpass parsing");
        }
    }

    @Override
    public void response() {
        session.response(HttpStatus.SC_OK, JsonType.NORMAL.toString(pkpassZip));
    }

    private boolean isEventReservation(final Object json)
        throws JsonUnexpectedTokenException
    {
        if (json instanceof Map) {
            Map<?, ?> micro = ValueUtils.asMap(json);
            if (micro.containsKey(TYPE)) {
                String vl = ValueUtils.asString(micro.get(TYPE));
                return vl.equals("EventReservation");
            }
        }
        return false;
    }

    private String asString(final Object o)
        throws JsonUnexpectedTokenException
    {
        String res = "";
        if (o instanceof String) {
            res = ValueUtils.asString(o);
        } else if (o instanceof JsonString) {
            res = ((JsonString) o).asString();
        }
        return res;
    }
}
