package ru.yandex.iex.proxy.eventtickethandler.entrails;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.iex.proxy.eventtickethandler.EventTicketContext;

abstract class AbstractCallbackChain
    implements FutureCallback<Object>
{
    public static final int MOVIE = 2;
    public static final int CONCERT = 3;
    public static final int OTHER = 5;
    protected int mask;

    protected AbstractCallbackChain next;

    public AbstractCallbackChain setNext(final AbstractCallbackChain chain) {
        next = chain;
        return chain;
    }

    public void executeMessage(
        final EventTicketContext context,
        final int priority)
    {
        if (priority <= mask) {
            execute(context);
        }
        if (next != null) {
            next.executeMessage(context, priority);
        }
    }

    public void setMask(final int mask) {
        this.mask = mask;
    }

    abstract void execute(final EventTicketContext context);
}
