package ru.yandex.iex.proxy.extractors;

import ru.yandex.dbfields.ChangeType;
import ru.yandex.json.dom.JsonObject;

public class ChangeLogRecord {
    private final long uid;
    // For caching purposes we need to distinguish from different operations
    // for the same emails. This is the suffix which will be added to filter
    // search requests, so we won't take cached value on email change
    // For DB induced records this will be `revision:12345', while for clicks
    // this will be `zoo-queue-id:23456'.
    private final String changeId;
    private final ChangeType changeType;
    // In seconds since epoch
    private final double changeDate;
    // Usually a list of changed emails, but can be JsonNull
    private final JsonObject changed;
    // Usually a map with DB operation arguments
    private final JsonObject arguments;

    public ChangeLogRecord(
        final long uid,
        final String changeId,
        final ChangeType changeType,
        final double changeDate,
        final JsonObject changed,
        final JsonObject arguments)
    {
        this.uid = uid;
        this.changeId = changeId;
        this.changeType = changeType;
        this.changeDate = changeDate;
        this.changed = changed;
        this.arguments = arguments;
    }

    public long uid() {
        return uid;
    }

    public String changeId() {
        return changeId;
    }

    public ChangeType changeType() {
        return changeType;
    }

    public double changeDate() {
        return changeDate;
    }

    public JsonObject changed() {
        return changed;
    }

    public JsonObject arguments() {
        return arguments;
    }
}

