package ru.yandex.iex.proxy.extractors;

import java.util.Collections;
import java.util.List;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.util.AbstractFilterFutureCallback;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.iex.proxy.IexProxy;
import ru.yandex.mail.so.factors.SoFactor;
import ru.yandex.mail.so.factors.SoFunctionInputs;
import ru.yandex.mail.so.factors.extractors.SoFactorsExtractor;
import ru.yandex.mail.so.factors.extractors.SoFactorsExtractorContext;
import ru.yandex.mail.so.factors.extractors.SoFactorsExtractorsRegistry;
import ru.yandex.mail.so.factors.types.LongSoFactorType;
import ru.yandex.mail.so.factors.types.SoFactorType;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.searchmap.User;
import ru.yandex.parser.uri.QueryConstructor;
import ru.yandex.search.prefix.LongPrefix;
import ru.yandex.search.proxy.SearchResultConsumerFactory;
import ru.yandex.search.proxy.universal.PlainUniversalSearchProxyRequestContext;
import ru.yandex.search.proxy.universal.UniversalSearchProxyRequestContext;
import ru.yandex.search.result.SearchResult;

public class UserTypeExtractor implements SoFactorsExtractor {
    private static final List<SoFactorType<?>> INPUTS =
        Collections.singletonList(LongSoFactorType.LONG);
    private static final List<SoFactorType<?>> OUTPUTS =
        Collections.singletonList(UserTypeSoFactorType.USER_TYPE);
    private static final List<SoFactor<?>> REGULAR_USER =
        Collections.singletonList(
            UserTypeSoFactorType.USER_TYPE.createFactor(UserType.REGULAR));
    private static final List<SoFactor<?>> TRUSTED_USER =
        Collections.singletonList(
            UserTypeSoFactorType.USER_TYPE.createFactor(UserType.TRUSTED));
    private static final List<SoFactor<?>> SO_COMPAINS_USER =
        Collections.singletonList(
            UserTypeSoFactorType.USER_TYPE.createFactor(UserType.SO_COMPAINS));

    private final IexProxy iexProxy;

    public UserTypeExtractor(final IexProxy iexProxy) {
        this.iexProxy = iexProxy;
    }

    @Override
    public void close() {
    }

    @Override
    public List<SoFactorType<?>> inputs() {
        return INPUTS;
    }

    @Override
    public List<SoFactorType<?>> outputs() {
        return OUTPUTS;
    }

    @Override
    public void registerInternals(final SoFactorsExtractorsRegistry registry)
        throws ConfigException
    {
        registry.typesRegistry().registerSoFactorType(LongSoFactorType.LONG);
        registry.typesRegistry().registerSoFactorType(
            UserTypeSoFactorType.USER_TYPE);
    }

    @Override
    public void extract(
        final SoFactorsExtractorContext context,
        final SoFunctionInputs inputs,
        final FutureCallback<? super List<SoFactor<?>>> callback)
    {
        Long uidBoxed = inputs.get(0, LongSoFactorType.LONG);
        if (uidBoxed == null) {
            callback.completed(NULL_RESULT);
            return;
        }
        long uid = uidBoxed.longValue();
        if (uid == 991949281L) {
            callback.completed(SO_COMPAINS_USER);
            return;
        }
        String queue = iexProxy.config().factsIndexingQueueName();
        AsyncClient client =
            iexProxy.searchClient().adjust(context.httpContext());
        UniversalSearchProxyRequestContext requestContext =
            new PlainUniversalSearchProxyRequestContext(
                new User(queue, new LongPrefix(uid)),
                null,
                true,
                client,
                context.logger());
        try {
            QueryConstructor query = new QueryConstructor(
                "/search-iex-proxy-complains?IO_PRIO=100");
            query.append("prefix", uid);
            query.append("service", queue);
            query.append("json-type", "dollar");
            query.append("get", "url");
            query.append("text", "url:so_trusted_complainer_" + uid);
            iexProxy.sequentialRequest(
                context,
                context.requestsListener(),
                context.httpContext(),
                requestContext,
                new BasicAsyncRequestProducerGenerator(query.toString()),
                null,
                true,
                SearchResultConsumerFactory.OK,
                context.requestsListener().createContextGeneratorFor(client),
                new Callback(callback));
        } catch (BadRequestException e) {
            callback.failed(e);
        }
    }

    private static class Callback
        extends AbstractFilterFutureCallback<SearchResult, List<SoFactor<?>>>
    {
        Callback(final FutureCallback<? super List<SoFactor<?>>> callback) {
            super(callback);
        }

        @Override
        public void completed(final SearchResult result) {
            if (result.hitsCount() == 0) {
                callback.completed(REGULAR_USER);
            } else {
                callback.completed(TRUSTED_USER);
            }
        }
    }
}

