package ru.yandex.iex.proxy.flightextractor;

import java.util.Map;

import ru.yandex.iex.proxy.flightextractor.flightabstructs.AbstractExtractor;
import ru.yandex.iex.proxy.flightextractor.flightabstructs.EmptyExtractor;
import ru.yandex.iex.proxy.flightextractor.flightabstructs.FlightExtractorEntrails;
import ru.yandex.iex.proxy.flightextractor.flightsources.BgoperatorExtractor;
import ru.yandex.iex.proxy.flightextractor.flightsources.BlablacarExtractor;
import ru.yandex.iex.proxy.flightextractor.flightsources.CoralExtractor;
import ru.yandex.iex.proxy.flightextractor.flightsources.Go2SeeExtractor;
import ru.yandex.iex.proxy.flightextractor.flightsources.PegastExtractor;
import ru.yandex.iex.proxy.flightextractor.flightsources.SindbadExtractor;
import ru.yandex.iex.proxy.flightextractor.flightsources.SunmarExtractor;
import ru.yandex.iex.proxy.flightextractor.flightsources.SuperkassaExtractor;
import ru.yandex.iex.proxy.flightextractor.flightsources.ThyExtractor;

public class FlightExtractor extends FlightExtractorEntrails {
    public FlightExtractor(
        final String domain,
        final long receivedDate,
        final String text)
    {
        super(domain, receivedDate, text);
    }

    public FlightExtractor(
        final String domain,
        final long receivedDate,
        final Map<?, ?> obj)
    {
        super(domain, receivedDate, obj);
    }

    @Override
    protected AbstractExtractor getExtractor(
        final SourceTypes type,
        final long receivedDate,
        final Object obj)
    {
        AbstractExtractor extractor;
        if (type.equals(SourceTypes.THY)) {
            extractor = new ThyExtractor(obj, receivedDate);
        } else if (type.equals(SourceTypes.CORAL_RU)) {
            extractor = new CoralExtractor(obj);
        } else if (type.equals(SourceTypes.BLABLACAR)) {
            extractor = new BlablacarExtractor(obj);
        } else if (type.equals(SourceTypes.SINDBAD)) {
            extractor = new SindbadExtractor(obj);
        } else if (type.equals(SourceTypes.GO2SEE)) {
            extractor = new Go2SeeExtractor(obj);
        } else if (type.equals(SourceTypes.SUNMAR)) {
            extractor = new SunmarExtractor(obj);
        } else if (type.equals(SourceTypes.SUPERKASSA)) {
            extractor = new SuperkassaExtractor(obj);
        } else if (type.equals(SourceTypes.PEGAST)) {
            extractor = new PegastExtractor(obj);
        } else if (type.equals(SourceTypes.BGOPERATOR)) {
            extractor = new BgoperatorExtractor(obj);
        } else {
            extractor = new EmptyExtractor(obj);
        }
        return extractor;
    }

    @Override
    protected SourceTypes getTypesOfSource(final String dom) {
        SourceTypes res = SourceTypes.UNKNOWN;
        if (dom.endsWith("thy.com")) {
            res = SourceTypes.THY;
        } else if (dom.endsWith("coral.ru")) {
            res = SourceTypes.CORAL_RU;
        } else if (dom.endsWith("blablacar.ru")) {
            res = SourceTypes.BLABLACAR;
        } else if (dom.endsWith("sindbad.ru")) {
            res = SourceTypes.SINDBAD;
        } else if (dom.endsWith("go2see.ru")) {
            res = SourceTypes.GO2SEE;
        } else if (dom.endsWith("sunmar.ru")) {
            res = SourceTypes.SUNMAR;
        } else if (dom.endsWith("superkassa.ru")) {
            res = SourceTypes.SUPERKASSA;
        } else if (dom.endsWith("pegast.su")) {
            res = SourceTypes.PEGAST;
        } else if (dom.endsWith("bgoperator.com")) {
            res = SourceTypes.BGOPERATOR;
        }
        return res;
    }
}
