package ru.yandex.iex.proxy.flightextractor.flightabstructs;

import java.util.HashMap;
import java.util.Map;

public abstract class AbstractExtractor {
    private static final String UNDEFINED_MSG = "undefined, status 3";

    protected String text = "";
    protected Map<?, ?> map = new HashMap<>();

    public AbstractExtractor(final Object obj) {
        if (obj instanceof String) {
            text = (String) obj;
        } else if (obj instanceof Map) {
            map = (Map<?, ?>) obj;
            map.entrySet().removeIf(entry -> isEmptyValue(entry.getValue()));
        }
    }

    private boolean isEmptyValue(final Object value) {
        return value instanceof String
            && (((String) value).isEmpty() || value.equals(UNDEFINED_MSG));
    }

    public abstract InterfaceDataProvider createTypeSpecificExtractor();
}
