package ru.yandex.iex.proxy.flightextractor.flightabstructs;

import java.util.HashMap;
import java.util.Map;

public class EmptyExtractor extends AbstractExtractor {
    private Map<String, Object> stub = new HashMap<>();

    public EmptyExtractor(final Object t) {
        super(t);
        for (Map.Entry<?, ?> x : map.entrySet()) {
            String key = (String) x.getKey();
            stub.put(key, x.getValue());
        }
    }

    public InterfaceDataProvider createTypeSpecificExtractor() {
        return new DefaultDataProvider();
    }

    class DefaultDataProvider extends UndefinedDataProvider {
        @Override
        public String getOrigin() { return "DEFAULT_EXTRACTOR"; }

        @Override
        public Map<String, Object> getStub() {
            return stub;
        }
    }
}
