package ru.yandex.iex.proxy.flightextractor.flightsources;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

import ru.yandex.iex.proxy.XRegexpUtils;
import ru.yandex.iex.proxy.flightextractor.flightabstructs.AbstractExtractor;
import ru.yandex.iex.proxy.flightextractor.flightabstructs.InterfaceDataProvider;
import ru.yandex.iex.proxy.flightextractor.flightabstructs.UndefinedDataProvider;

public class BgoperatorExtractor extends AbstractExtractor {
    public static final String NUMBER = "number";
    public static final String SPACE = "\\s";
    private static final Pattern URL =
        Pattern.compile("http[^<]+");
    private String arrCity = "";
    private String depCity = "";
    private String depDate = "";
    private String arrDate = "";
    private Map<String, Object> stub = new HashMap<>();

    public BgoperatorExtractor(final Object t) {
        super(t);
        Object arr = map.get("airport_arr");
        if (arr instanceof String) {
            String[] tok = ((String) arr).split(SPACE);
            if (tok.length > 2) {
                arrCity = tok[2];
            }
        }
        Object dep = map.get("airport_dep");
        if (dep instanceof String) {
            String[] tok1 = ((String) dep).split(SPACE);
            if (tok1.length > 2) {
                depCity = tok1[2];
            }
        }
        Object depDateL = map.get("date_dep");
        if (depDateL instanceof String) {
            depDate = (String) depDateL;
        }
        Object dateDep = map.get("dep_date");
        if (dateDep instanceof String) {
            String tmpDate = (String) dateDep;
            if (tmpDate.matches("вылет [0-9]{2}.[0-9]{2}.[0-9]{4}")) {
                String[] deptmp = depDate.split(SPACE);
                //CSOFF: AvoidInlineConditionals
                depDate =
                    tmpDate.split(SPACE)[1] + ' '
                        + (deptmp.length > 0 ? deptmp[1] : "");
                //CSON: AvoidInlineConditionals
            }
        }
        Object number = map.get(NUMBER);
        if (number instanceof String) {
            stub.put(NUMBER, ((String) number).replace("[^0-9]*", ""));
        }
        Object url = map.get("tour_info_url");
        if (url instanceof String) {
            stub.put(
                "url",
                XRegexpUtils.parseOnce(URL.matcher((String) url), 0));
        }
    }

    public InterfaceDataProvider createTypeSpecificExtractor() {
        return new BgoperatorDataProvider();
    }

    class BgoperatorDataProvider extends UndefinedDataProvider {
        @Override
        public String getFlightDepDate() {
            return depDate;
        }

        @Override
        public String getFlightArrDate() {
            return arrDate;
        }

        @Override
        public String getFlightDepCity() {
            return depCity;
        }

        @Override
        public String getFlightArrCity() {
            return arrCity;
        }

        @Override
        public Map<String, Object> getStub() {
            return stub;
        }

        @Override
        public String getOrigin() { return "BGOPERATOR_EXTRACTOR"; }
    }
}
