package ru.yandex.iex.proxy.flightextractor.flightsources;

import ru.yandex.iex.proxy.flightextractor.flightabstructs.AbstractExtractor;
import ru.yandex.iex.proxy.flightextractor.flightabstructs.InterfaceDataProvider;
import ru.yandex.iex.proxy.flightextractor.flightabstructs.UndefinedDataProvider;

public class BlablacarExtractor extends AbstractExtractor {
    private String depCity = "";
    private String arrCity = "";
    private String depDate = "";

    public BlablacarExtractor(final Object o) {
        super(o);
        Object rawCity = map.get("raw_city");
        if (rawCity != null) {
            String rawc = (String) rawCity;
            String[] cs = rawc.split("\\s→\\s");
            if (cs.length > 0) {
                depCity = cs[0];
            }
            if (cs.length > 1) {
                arrCity = cs[1];
            }
        }
        Object date = map.get("date_dep");
        if (date != null) {
            depDate = (String) date;
        }
    }

    public InterfaceDataProvider createTypeSpecificExtractor() {
        return new BlablacarDataProvider();
    }

    class BlablacarDataProvider extends UndefinedDataProvider {
        @Override
        public String getFlightDepDate() {
            return depDate;
        }

        @Override
        public String getFlightDepCity() {
            return depCity;
        }

        @Override
        public String getFlightArrCity() {
            return arrCity;
        }

        @Override
        public String getOrigin() { return "BLABLACAR_EXTRACTOR"; }

        @Override
        public String getWidgetSubtype() {
            return "caroffer";
        }
    }
}
