package ru.yandex.iex.proxy.flightextractor.flightsources;

import java.util.ArrayList;
import java.util.regex.Pattern;

import ru.yandex.iex.proxy.XRegexpUtils;
import ru.yandex.iex.proxy.flightextractor.flightabstructs.AbstractExtractor;
import ru.yandex.iex.proxy.flightextractor.flightabstructs.InterfaceDataProvider;
import ru.yandex.iex.proxy.flightextractor.flightabstructs.UndefinedDataProvider;

/**
 * text input example:
 * 23.01.2016 Khabarovsk(Khabarovsk) -> Phuket INT Airport(Phuket INT Airport)
 * Nord Wind-N4 2487 (Economy) [10:05-15:30] 20 Pax:2 + 0 INF [1]
 */

public class CoralExtractor extends AbstractExtractor {
    private static final String DATEP = "[0-9]{2}\\.[0-9]{2}\\.[0-9]{4}";
    private static final Pattern DEPCITYR =
        Pattern.compile(DATEP + " (.*?) ->");
    private static final Pattern DATER = Pattern.compile(DATEP);
    private static final Pattern ARRCITYR =
        Pattern.compile("-> (.*?)\\)");
    private static final String SEC = ":00";
    private String arrCity = "";
    private String depCity = "";
    private String flightNumber = "";
    private String commonDate = "";
    private String depDate = "";
    private String arrDate = "";

    public CoralExtractor(final Object t) {
        super(t);
        commonDate = XRegexpUtils.parseOnce(DATER.matcher(text), 0);
        depCity = XRegexpUtils.parseOnce(DEPCITYR.matcher(text), 1);
        arrCity = XRegexpUtils.parseOnce(ARRCITYR.matcher(text), 1);
        ArrayList<String> times = XRegexpUtils.getAllTimes(text);
        if (!times.isEmpty()) {
            depDate = commonDate + ' ' + times.get(0) + SEC;
        }
        if (times.size() > 1) {
            arrDate = commonDate + ' ' + times.get(1) + SEC;
        }
        flightNumber = "undefined";
    }

    public InterfaceDataProvider createTypeSpecificExtractor() {
        return new CoralDataProvider();
    }

    class CoralDataProvider extends UndefinedDataProvider {
        @Override
        public String getFlightNumber() {
            return flightNumber;
        }

        @Override
        public String getFlightDepDate() {
            return depDate;
        }

        @Override
        public String getFlightArrDate() {
            return arrDate;
        }

        @Override
        public String getFlightDepCity() {
            return depCity;
        }

        @Override
        public String getFlightArrCity() {
            return arrCity;
        }

        @Override
        public String getOrigin() { return "CORAL_EXTRACTOR"; }
    }
}
