package ru.yandex.iex.proxy.flightextractor.flightsources;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import ru.yandex.iex.proxy.XRegexpUtils;
import ru.yandex.iex.proxy.XTimeUtils;
import ru.yandex.iex.proxy.flightextractor.flightabstructs.AbstractExtractor;
import ru.yandex.iex.proxy.flightextractor.flightabstructs.InterfaceDataProvider;
import ru.yandex.iex.proxy.flightextractor.flightabstructs.UndefinedDataProvider;

public class Go2SeeExtractor extends AbstractExtractor {
    public static final String S_S = "\\s–\\s";
    private static final String PAYMENT_URL = "payment_url";

    private String depCity = "";
    private String arrCity = "";
    private String depCityBack = "";
    private String arrCityBack = "";
    private String depDate = "";
    private String arrDate = "";
    private String depDateBack = "";
    private String arrDateBack = "";
    private Map<String, Object> stub = new HashMap<>();

    public Go2SeeExtractor(final Object o) {
        super(o);
        Object rawCity = map.get("city_from_to_1");
        if (rawCity != null) {
            String rawc = (String) rawCity;
            String[] cs = rawc.split(S_S);
            if (cs.length > 0) {
                depCity = cs[0];
            }
            if (cs.length > 1) {
                arrCity = cs[1];
            }
        }
        rawCity = map.get("city_from_to_2");
        if (rawCity != null) {
            String rawc = (String) rawCity;
            String[] cs = rawc.split(S_S);
            if (cs.length > 0) {
                depCityBack = cs[0];
                stub.put("city_dep_back", depCityBack);
            }

            if (cs.length > 1) {
                arrCityBack = cs[1];
                stub.put("city_arr_back", arrCityBack);
            }
            stub.put("flight_number_back", "undefined");
        }
        Object f1 = map.get("date_dep_arr_1");
        if (f1 != null) {
            String rawText = (String) f1;
            ArrayList<String> times = XRegexpUtils.getAllTimes(rawText);
            ArrayList<String> dates = XRegexpUtils.getAllDates(rawText);
            if (!times.isEmpty() && !dates.isEmpty()) {
                depDate = XTimeUtils.makeIexDateFromRuFormat(
                    dates.get(0),
                    times.get(0));
            }
            if (times.size() > 1 && dates.size() > 1) {
                arrDate = XTimeUtils.makeIexDateFromRuFormat(
                    dates.get(1),
                    times.get(1));
            }
        }
        f1 = map.get("date_dep_arr_2");
        if (f1 != null) {
            String rawText = (String) f1;
            ArrayList<String> times = XRegexpUtils.getAllTimes(rawText);
            ArrayList<String> dates = XRegexpUtils.getAllDates(rawText);
            if (!times.isEmpty() && !dates.isEmpty()) {
                depDateBack = XTimeUtils.makeIexDateFromRuFormat(
                    dates.get(0),
                    times.get(0));
                stub.put("date_dep_back", depDateBack);
                stub.put("time_dep_back", depDateBack);
            }
            if (times.size() > 1 && dates.size() > 1) {
                arrDateBack = XTimeUtils.makeIexDateFromRuFormat(
                    dates.get(1),
                    times.get(1));
                stub.put("date_arr_back", arrDateBack);
                stub.put("time_arr_back", arrDateBack);
            }
        }
        stub.put(PAYMENT_URL, map.get(PAYMENT_URL));
    }

    public InterfaceDataProvider createTypeSpecificExtractor() {
        return new Go2SeeDataProvider();
    }

    class Go2SeeDataProvider extends UndefinedDataProvider {
        @Override
        public String getFlightDepDate() {
            return depDate;
        }

        @Override
        public String getFlightArrDate() {
            return arrDate;
        }

        @Override
        public String getFlightDepCity() {
            return depCity;
        }

        @Override
        public String getFlightArrCity() {
            return arrCity;
        }

        @Override
        public String getOrigin() { return "Go2See_EXTRACTOR"; }

        @Override
        public Map<String, Object> getStub() {
            return stub;
        }
    }
}
