package ru.yandex.iex.proxy.flightextractor.flightsources;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

import ru.yandex.iex.proxy.XRegexpUtils;
import ru.yandex.iex.proxy.flightextractor.flightabstructs.AbstractExtractor;
import ru.yandex.iex.proxy.flightextractor.flightabstructs.InterfaceDataProvider;
import ru.yandex.iex.proxy.flightextractor.flightabstructs.UndefinedDataProvider;

/*
N4 1695 Nord Wind NIZHNEKAMSK(NBC) [02:30] ->
HERAKLION(HER) [06:00] 08.05.2014 Y (STANDART)

N4 1696 Nord Wind HERAKLION(HER) [17:45] ->
 NIZHNEKAMSK(NBC) [23:15] 17.05.2014 Y (STANDART)
 */
public class PegastExtractor extends AbstractExtractor {
    private static final String SEC = ":00";
    private static final Pattern ARRCITYR =
        Pattern.compile("-> (.*?)\\(");
    private static final Pattern DEPCITYR =
        Pattern.compile("([A-Za-z]+)\\([A-Z]+\\) \\[[0-9]{2}:[0-9]{2}\\] ->");
    private String arrCity = "";
    private String depCity = "";
    private String flightNumber = "";
    private String depDate = "";
    private String arrDate = "";
    private String depDateBack = "";
    private String arrDateBack = "";
    private String flightNumberBack = "";
    private Map<String, Object> stub = new HashMap<>();

    public PegastExtractor(final Object t) {
        super(t);
        Object rawText = map.get("raw_1");
        if (rawText instanceof String) {
            String rawTextTxt = (String) rawText;
            arrCity = XRegexpUtils.parseOnce(ARRCITYR.matcher(rawTextTxt), 1);
            depCity = XRegexpUtils.parseOnce(DEPCITYR.matcher(rawTextTxt), 1);
            ArrayList<String> dates =
                XRegexpUtils.getAllCommaSepedDates(rawTextTxt);
            ArrayList<String> times =
                XRegexpUtils.getAllTimes(rawTextTxt);
            ArrayList<String> flightNumbers =
                XRegexpUtils.getAllFlightNumbers(rawTextTxt);
            if (!dates.isEmpty()) {
                String commonDate = dates.get(0);
                if (!times.isEmpty()) {
                    depDate = commonDate + ' ' + times.get(0) + SEC;
                }
                if (times.size() > 1) {
                    arrDate = commonDate + ' ' + times.get(1) + SEC;
                }
                if (!flightNumbers.isEmpty()) {
                    flightNumber = flightNumbers.get(0);
                }
            }
            if (dates.size() > 1) {
                String commonDate = dates.get(1);
                if (times.size() > 2) {
                    depDateBack = commonDate + ' ' + times.get(2) + SEC;
                    stub.put("date_dep_back", depDateBack);
                }
                if (times.size() > 1 + 2) {
                    arrDateBack = commonDate + ' ' + times.get(1 + 2) + SEC;
                    stub.put("date_arr_back", arrDateBack);
                }
                if (flightNumbers.size() > 1) {
                    flightNumberBack = flightNumbers.get(1);
                    stub.put("flight_number_back", flightNumberBack);
                }
            }
        }
    }

    public InterfaceDataProvider createTypeSpecificExtractor() {
        return new PegastDataProvider();
    }

    class PegastDataProvider extends UndefinedDataProvider {
        @Override
        public String getFlightNumber() {
            return flightNumber;
        }

        @Override
        public String getFlightDepDate() {
            return depDate;
        }

        @Override
        public String getFlightArrDate() {
            return arrDate;
        }

        @Override
        public String getFlightDepCity() {
            return depCity;
        }

        @Override
        public String getFlightArrCity() {
            return arrCity;
        }

        @Override
        public String getOrigin() { return "PEGAST_EXTRACTOR"; }

        @Override
        public Map<String, Object> getStub() {
            return stub;
        }
    }
}
