package ru.yandex.iex.proxy.flightextractor.flightsources;

import java.util.HashMap;
import java.util.Map;

import ru.yandex.iex.proxy.flightextractor.flightabstructs.AbstractExtractor;
import ru.yandex.iex.proxy.flightextractor.flightabstructs.InterfaceDataProvider;
import ru.yandex.iex.proxy.flightextractor.flightabstructs.UndefinedDataProvider;

public class SindbadExtractor extends AbstractExtractor {
    private static final String PAYMENT_URL = "payment_url";

    private String depCity = "";
    private String arrCity = "";
    private String depDate = "";
    private Map<String, Object> stub = new HashMap<>();

    public SindbadExtractor(final Object o) {
        super(o);
        Object rawCity = map.get("city_dep");
        if (rawCity instanceof String) {
            depCity = (String) rawCity;
        }
        rawCity = map.get("city_arr");
        if (rawCity instanceof String) {
            arrCity = (String) rawCity;
        }
        Object date = map.get("date_dep");
        if (date instanceof String) {
            depDate = (String) date;
        }
        stub.put(PAYMENT_URL, map.get(PAYMENT_URL));
    }

    public InterfaceDataProvider createTypeSpecificExtractor() {
        return new SindbadDataProvider();
    }

    class SindbadDataProvider extends UndefinedDataProvider {
        @Override
        public String getFlightDepDate() {
            return depDate;
        }

        @Override
        public String getFlightDepCity() {
            return depCity;
        }

        @Override
        public String getFlightArrCity() {
            return arrCity;
        }

        @Override
        public String getOrigin() { return "SINDBAD_EXTRACTOR"; }

        @Override
        public Map<String, Object> getStub() {
            return stub;
        }
    }
}
