package ru.yandex.iex.proxy.flightextractor.flightsources;

import java.util.ArrayList;
import java.util.regex.Pattern;

import ru.yandex.iex.proxy.XRegexpUtils;
import ru.yandex.iex.proxy.flightextractor.flightabstructs.AbstractExtractor;
import ru.yandex.iex.proxy.flightextractor.flightabstructs.InterfaceDataProvider;
import ru.yandex.iex.proxy.flightextractor.flightabstructs.UndefinedDataProvider;

/**
 * Input:
 * 11.03.2017 Sheremetyevo(Sheremetyevo-C) -> Bangkok Airport(Suvarnabhumi)
 * Nord Wind-N4 721 (Economy) [22:25-11:10 +1]  Pax:2 + 0 INF [1]
 */
public class SunmarExtractor extends AbstractExtractor {
    private static final String DATEP = "[0-9]{2}\\.[0-9]{2}\\.[0-9]{4}";
    private static final Pattern DEPCITYR =
        Pattern.compile(DATEP + " (.*?) ->");
    private static final Pattern DATER = Pattern.compile(DATEP);
    private static final Pattern ARRCITYR =
        Pattern.compile("-> (.*?)\\)");
    private static final String SEC = ":00";
    private String arrCity = "";
    private String depCity = "";
    private String flightNumber = "";
    private String commonDate = "";
    private String depDate = "";
    private String arrDate = "";

    public SunmarExtractor(final Object t) {
        super(t);
        commonDate = XRegexpUtils.parseOnce(DATER.matcher(text), 0);
        depCity = XRegexpUtils.parseOnce(DEPCITYR.matcher(text), 1);
        arrCity = XRegexpUtils.parseOnce(ARRCITYR.matcher(text), 1);
        if (arrCity != null && !arrCity.isEmpty()) {
            arrCity += ')';
        }
        ArrayList<String> times = XRegexpUtils.getAllTimes(text);
        if (!times.isEmpty()) {
            depDate = commonDate + ' ' + times.get(0) + SEC;
        }
        if (times.size() > 1) {
            arrDate = commonDate + ' ' + times.get(1) + SEC;
        }
        flightNumber = "undefined";
    }

    public InterfaceDataProvider createTypeSpecificExtractor() {
        return new SunmarDataProvider();
    }

    class SunmarDataProvider extends UndefinedDataProvider {
        @Override
        public String getFlightNumber() {
            return flightNumber;
        }

        @Override
        public String getFlightDepDate() {
            return depDate;
        }

        @Override
        public String getFlightArrDate() {
            return arrDate;
        }

        @Override
        public String getFlightDepCity() {
            return depCity;
        }

        @Override
        public String getFlightArrCity() {
            return arrCity;
        }

        @Override
        public String getOrigin() { return "SUNMAR_EXTRACTOR"; }
    }
}
