package ru.yandex.iex.proxy.flightextractor.flightsources;

import java.util.ArrayList;
import java.util.regex.Pattern;

import ru.yandex.iex.proxy.XRegexpUtils;
import ru.yandex.iex.proxy.XTimeUtils;
import ru.yandex.iex.proxy.flightextractor.flightabstructs.AbstractExtractor;
import ru.yandex.iex.proxy.flightextractor.flightabstructs.InterfaceDataProvider;
import ru.yandex.iex.proxy.flightextractor.flightabstructs.UndefinedDataProvider;

public class SuperkassaExtractor extends AbstractExtractor {
    private static final Pattern CITIES =
        Pattern.compile("([^\\s]*,[^,]*)[,]");
    private String arrCity = "";
    private String depCity = "";
    private String depDate = "";
    private String arrDate = "";
    private String cities = "";

    public SuperkassaExtractor(final Object t) {
        super(t);
        Object rawData = map.get("raw_data");
        if (rawData instanceof String) {
            String text = (String) rawData;
            cities = XRegexpUtils.parseOnce(CITIES.matcher(text), 1);
            if (!cities.isEmpty()) {
                String[] ct = cities.split(" - ");
                if (ct.length == 2) {
                    depCity = ct[0].replaceAll(",[^,]*$", "");
                    arrCity = ct[1];
                }
            }
            //TODO: in Go2SeeExtractor there is the same
            ArrayList<String> times = XRegexpUtils.getAllTimes(text);
            ArrayList<String> dates = XRegexpUtils.getAllDates(text);
            if (!times.isEmpty() && !dates.isEmpty()) {
                depDate = XTimeUtils.makeIexDateFromRuFormat(
                    dates.get(0),
                    times.get(0));
            }
            if (times.size() > 1 && dates.size() > 1) {
                arrDate = XTimeUtils.makeIexDateFromRuFormat(
                    dates.get(1),
                    times.get(1));
            }
        }
    }

    public InterfaceDataProvider createTypeSpecificExtractor() {
        return new SuperkassaDataProvider();
    }

    class SuperkassaDataProvider extends UndefinedDataProvider {
        @Override
        public String getFlightDepDate() {
            return depDate;
        }

        @Override
        public String getFlightArrDate() {
            return arrDate;
        }

        @Override
        public String getFlightDepCity() {
            return depCity;
        }

        @Override
        public String getFlightArrCity() {
            return arrCity;
        }

        @Override
        public String getOrigin() { return "SUPERKASSA_EXTRACTOR"; }
    }
}
