package ru.yandex.iex.proxy.hotelshandlerlegacy;

import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

import org.apache.http.HttpException;
import org.apache.http.HttpStatus;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.iex.proxy.AbstractEntityContext;
import ru.yandex.iex.proxy.IexProxy;
import ru.yandex.iex.proxy.XJsonUtils;
import ru.yandex.iex.proxy.XMessageToLog;
import ru.yandex.iex.proxy.XStrAlgo;
import ru.yandex.iex.proxy.XTimeUtils;
import ru.yandex.iex.proxy.XTools;
import ru.yandex.iex.proxy.tickethandlerlegacy.TicketWidgetType;
import ru.yandex.iex.proxy.xutils.PriceFormat;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;
import ru.yandex.json.xpath.ValueUtils;

public class HotelsContext extends AbstractEntityContext {
    public static final String LINK = "link";
    public static final String HOTEL = "hotel";
    public static final String SUBJECT = "subject";
    public static final String HOTELS = "hotels";
    public static final String EMAIL = "email";
    public static final String UNKNOWN = "unknown";
    public static final String NUMBER_OF_NIGHTS = "number_of_nights";
    public static final String URL = "url";
    public static final String PDF = "pdf";
    public static final String HID = "hid_";
    public static final String CANCELING = "canceling";
    public static final String CANCELLED_RESERVATION = "cancelled_reservation";
    public static final String RESERVATION_STATUS = "reservationStatus";
    public static final String DOMAIN = "domain";
    public static final String IEX_MSG = "iex_msg";
    public static final String MICRO = "micro";
    public static final String REMINDER = "reminder";
    public static final String CITY_GEOID = "city_geoid";
    public static final String XPATH_XPATH = "xpath_xpath";
    public static final String ORIGIN = "origin";
    public static final String HOTEL_BOOKING = "hotel_booking";
    public static final String UNDEFINED_STATUS_3 = "undefined, status 3";
    public static final String MICROHTML = "microhtml";
    public static final String CANCELLATION_INFO = "cancellation_info";

    private static final String NULL = "null";
    // TODO: emun or list or config-data are required
    // or smth more flexible then static final String
    //MICRO source symbols
    private static final String STATUS = RESERVATION_STATUS;
    private static final String STATUS1 = "status";
    private static final String CHECKIND = "checkinDate";
    private static final String CHECKOUTD = "checkoutDate";
    private static final String RESNUM = "reservationNumber";
    private static final String HNAME = "name";
    private static final String NUMADULT = "numAdults";
    private static final String NUMCHILD = "numChildren";
    private static final String MURL = "modifyReservationUrl";
    private static final String ADDRESS = "address";
    private static final String PRICE = "price";
    private static final String PRICE_CURRENCY = "priceCurrency";
    //addresss
    private static final String STREET = "streetAddress";
    private static final String POSTAL = "postalCode";
    private static final String CITY = "addressLocality";
    private static final String COUNTRY = "addressCountry";
    //IEX source symbols
    private static final String IEXPEOPLE = "people";
    private static final String IEXHNAME = HOTEL;
    private static final String IEXCHECKIND = "check-inn_date";
    private static final String IEXCHECKOUTD = "check-out_date";
    private static final String IEXCOUNTRY = "country";
    private static final String IEXCITY = "city";
    private static final String IEXRESNUM = "reservation_number";
    private static final String COMMA = ", ";
    private static final String CHECKIN_DATE = "checkin_date";
    private static final String CHECKOUT_DATE = "checkout_date";
    private static final Map<String, String> MFIELD;
    private static final Map<String, String> RENAMETABLE;
    private static final ArrayList<String> REMINDERS_STATUS
        = new ArrayList<>(Arrays.asList("Ваша поездка уже совсем скоро"));
    private Map<String, Object> result =
        new HashMap<String, Object>();
    private boolean isThereAdultOrChildField = false;
    private String uid;
    private String email;
    private List<String> attachements = null;
    private boolean originIexPatterns = false;
    private boolean originMicro = false;
    private long receivedDate = 0;
    private Map<?, ?> inputJson = null;
    //private XStrAlgo.HtmlSanitizer htmlSanitizer =
   //     new XStrAlgo.HtmlSanitizer();

    static {
        MFIELD = new HashMap<String, String>();
        MFIELD.put(CHECKIND, IEXCHECKIND);
        MFIELD.put(CHECKOUTD, IEXCHECKOUTD);
        MFIELD.put(RESNUM, IEXRESNUM);
        MFIELD.put(CITY, IEXCITY);
        MFIELD.put(COUNTRY, IEXCOUNTRY);
        MFIELD.put(HNAME, IEXHNAME);
        MFIELD.put(NUMADULT, IEXPEOPLE);
        MFIELD.put(NUMCHILD, IEXPEOPLE);
    }

    static {
        RENAMETABLE = new HashMap<>();
        RENAMETABLE.put(IEXCHECKIND, CHECKIN_DATE);
        RENAMETABLE.put(IEXCHECKOUTD, CHECKOUT_DATE);
        RENAMETABLE.put(IEXCHECKIND + RFC, CHECKIN_DATE + RFC);
        RENAMETABLE.put(IEXCHECKOUTD + RFC, CHECKOUT_DATE + RFC);
    }

    public HotelsContext(
        final IexProxy iexProxy,
        final ProxySession session,
        final Map<?, ?> json)
        throws HttpException, JsonUnexpectedTokenException
    {
        super(iexProxy, session, json);
        inputJson = json;
        uid = session().params().getString("uid");
        receivedDate =
            ValueUtils.asLong(session.params().getString("received_date"));
        email = session().params().getString(EMAIL);
        parsePdfData();
        originIexPatterns = extractInfoFromHotelsIexEntity();
        originMicro = extractBookingInfoFromMicroIexEntity();
        defineReminderParams();
        if (XJsonUtils.countOfKeys(result) == 0) {
            result = null;
        }
    }

    public Map<String, Object> getResult() {
        return result;
    }

    public String uid() {
        return uid;
    }

    public String getClientId() {
        return "yandex-hotel";
    }

    public boolean isResultPerfect() {
        return result != null
            && result.containsKey(IEXCHECKIND)
            && result.containsKey(IEXCHECKOUTD)
            && result.containsKey(IEXRESNUM)
            && result.containsKey(IEXHNAME)
            && result.containsKey(IEXCITY);
    }

    public void checkXPathSource() {
        Object xpath = XJsonUtils.getNodeByPathOrNullEless(
            json,
            HOTELS,
            XPATH_XPATH);
        if (xpath instanceof Map) {
            Map<?, ?> mxpath = (Map<?, ?>) xpath;
            Object url = mxpath.get(URL);
            if (url instanceof String
                && ((String) url).startsWith("http")
                || existsValidField(mxpath))
            {
                result = new HashMap<>();
                result.put(TicketWidgetType.TYPE, HOTEL_BOOKING);
                result.put(ORIGIN, XPATH_XPATH);
                for (Map.Entry<?, ?> x : mxpath.entrySet()) {
                    String key = (String) x.getKey();
                    Object value = x.getValue();
                    if (value instanceof String
                        && !value.equals(UNDEFINED_STATUS_3))
                    {
                        result.put(key, value);
                        if (key.equals(STATUS1)) {
                            boolean found = false;
                            for (String y : REMINDERS_STATUS) {
                                if (((String) value).contains(y)) {
                                    found = true;
                                    break;
                                }
                            }
                            if (found) {
                                result.put(TicketWidgetType.TYPE, REMINDER);
                            }
                        }
                    }
                }
            }
        }
    }

    public void getPriceFromXpath() {
        Map<?, ?> mxpath = (Map<?, ?>) XJsonUtils.getNodeByPathOrNullEless(
            json,
            HOTELS,
            XPATH_XPATH);
        if (mxpath != null && result != null) {
            Object price = mxpath.get(PRICE);
            if (price instanceof String && !price.equals(UNDEFINED_STATUS_3)) {
                result.put(PRICE, price);
            }
        }
    }

    public void getCancellationInfoFromXPath() {
        Map<?, ?> mxpath = (Map<?, ?>) XJsonUtils.getNodeByPathOrNullEless(
            json,
            HOTELS,
            XPATH_XPATH);
        if (mxpath != null && result != null) {
            Object cancelInfo = mxpath.get("cancelling_date");
            if (cancelInfo instanceof String
                && !cancelInfo.equals(UNDEFINED_STATUS_3))
            {
                if (!result.containsKey(CANCELLATION_INFO)) {
                    result.put(CANCELLATION_INFO, cancelInfo);
                }
            }
        }
    }

    private boolean existsValidField(final Map<?, ?> json) {
        Object resNums = json.get("reservation_number_array");
        Object guests = json.get("guest_array");
        Object checkinDate = json.get("checkin_date_array");
        return !resNums.equals(UNDEFINED_STATUS_3)
            && !guests.equals(UNDEFINED_STATUS_3)
            && !checkinDate.equals(UNDEFINED_STATUS_3);
    }

    public void response() {
        postParseAction();
        session.response(HttpStatus.SC_OK, JsonType.NORMAL.toString(result));
    }

    private void postParseAction() {
        if (result != null) {
            String[] times = {
                IEXCHECKIND,
                IEXCHECKOUTD
            };
            for (final String time : times) {
                XTimeUtils.changeTimeFormat(result, time);
            }
            long checkInTime = XTimeUtils.getTimestampFromDateAndTime(
                result,
                IEXCHECKIND,
                IEXCHECKIND);
            long checkOutTime = XTimeUtils.getTimestampFromDateAndTime(
                result,
                IEXCHECKOUTD,
                IEXCHECKOUTD);
            completeDateAndTime(
                result,
                new String[]{
                    IEXCHECKIND, // WITH DATE
                    IEXCHECKIND, // WITH TIME
                    IEXCHECKIND}); // WITH TZ
            completeDateAndTime(
                result,
                new String[]{
                    IEXCHECKOUTD, // WITH DATE
                    IEXCHECKOUTD, // WITH TIME
                    IEXCHECKOUTD}); // WITH TZ
            if (checkInTime != -1) {
                String type = "booking";
                if (result.containsKey(RESERVATION_STATUS)) {
                    Object value = result.get(RESERVATION_STATUS);
                    if (value instanceof String
                        && ((String) value).equals(
                        "http://schema.org/Cancelled"))
                    {
                        type = CANCELING;
                    }
                }
                if (result.containsKey(CANCELLED_RESERVATION)) {
                    Object value = result.get(CANCELLED_RESERVATION);
                    if (value instanceof Boolean) {
                        if ((Boolean) value) {
                            type = CANCELING;
                        }
                    }
                }
                if (result.containsKey(DOMAIN)) {
                    String domain = (String) result.get(DOMAIN);
                    if (domain.contains("yandex")) {
                        type = REMINDER;
                    }
                    if (domain.contains("wubook.net")) {
                        type = HOTEL_BOOKING;
                    }
                }
                if (!result.containsKey(TicketWidgetType.TYPE)) {
                    result.put(TicketWidgetType.TYPE, type);
                }
                result.put("date_dep_ts", String.valueOf(checkInTime));
            }
            for (final Map.Entry<String, String> x : RENAMETABLE.entrySet()) {
                if (result.containsKey(x.getKey())) {
                    Object v = result.get(x.getKey());
                    result.put(x.getValue(), v);
                    result.remove(x.getKey());
                }
            }
            XJsonUtils.renameKey(result, LINK, MURL);
            updateNumberOfNight(checkInTime, checkOutTime);
            result.put("print_parts", attachements);
            Object rawPrice = result.get(PRICE);
            Object rawCurrency = result.get(PRICE_CURRENCY);
            if (rawPrice instanceof String) {
                String currency = "";
                if (rawCurrency instanceof String) {
                    currency = (String) rawCurrency;
                }
                Map.Entry<String, String> formatted =
                    PriceFormat.extractPriceAndCurrency(
                        XStrAlgo.htmlSanitizer((String) rawPrice),
                        XStrAlgo.getOnlyAlphabetic(currency));
                String formattedPrice = formatted.getKey();
                String formattedCurrency = formatted.getValue();
                StringBuilder sb = new StringBuilder();
                sb.append(formattedPrice);
                if (!formattedCurrency.isEmpty()) {
                    sb.append(' ');
                    sb.append(formattedCurrency);
                }
                if (formattedPrice != null
                    && !formattedPrice.isEmpty())
                {
                    result.put(PRICE, sb.toString());
                }
            }
            //htmlSanitizer.mapSanitizer(result);
            formatDateAndTime(result, CANCELLATION_INFO);
            fillOrigin(result);
            fillIexMsg(result, checkInTime, checkOutTime);
        }
        addRawdata();
    }

    private void addRawdata() {
        if (result != null && inputJson != null) {
            Object map = XJsonUtils.getNodeByPathOrNullEless(inputJson, MICRO);
            Object unknown = XJsonUtils.getNodeByPathOrNullEless(map, UNKNOWN);
            if (unknown == null) {
                map = null;
            }
            if (map == null) {
                map = XJsonUtils.getNodeByPathOrNullEless(json, MICROHTML);
                unknown = XJsonUtils.getNodeByPathOrNullEless(map, UNKNOWN);
                if (unknown == null) {
                    map = null;
                }
            }
            result.put("rawdata", map);
        }
    }

    private void fillOrigin(final Map<String, Object> result) {
        String origin = "";
        if (originMicro) {
            origin += MICRO;
        }
        if (originIexPatterns) {
            if (!origin.isEmpty()) {
                origin += ',';
            }
            origin += "iex-patterns";
        }
        if (!result.containsKey(ORIGIN)) {
            result.put(ORIGIN, origin);
        }
    }

    private void fillIexMsg(
        final Map<String, Object> result,
        final long timeIn,
        final long timeOut)
    {
        if (timeIn < receivedDate) {
            XJsonUtils.addStr(result, IEX_MSG, "checkInTime < receivedDate");
        }
        if (!originMicro) {
            XJsonUtils.addStr(result, IEX_MSG, "micro missing");
        }
        if (!originIexPatterns) {
            XJsonUtils.addStr(result, IEX_MSG, "patterns missing");
        }
        boolean undefined = false;
        if (timeIn
            + XTimeUtils.dayInSeconds() * XTimeUtils.DAYS_IN_YEAR
                < receivedDate)
        {
            XJsonUtils.addStr(result, IEX_MSG, "invalid pcheckInDate");
            undefined = true;
        }
        if (timeIn > receivedDate
            + XTimeUtils.dayInSeconds() * XTimeUtils.DAYS_IN_YEAR)
        {
            XJsonUtils.addStr(result, IEX_MSG, "invalid fcheckInDate");
            undefined = true;
        }
        if (timeOut
            + XTimeUtils.dayInSeconds() * XTimeUtils.DAYS_IN_YEAR
                < receivedDate)
        {
            XJsonUtils.addStr(result, IEX_MSG, "invalid pcheckOutDate");
            undefined = true;
        }
        if (timeOut > receivedDate
            + XTimeUtils.dayInSeconds() * XTimeUtils.DAYS_IN_YEAR)
        {
            XJsonUtils.addStr(result, IEX_MSG, "invalid fcheckOutDate");
            undefined = true;
        }
        if (!result.containsKey(CITY_GEOID)) {
            XJsonUtils.addStr(result, IEX_MSG, "geocoder error");
        } else {
            Object geoid = result.get(CITY_GEOID);
            if (geoid instanceof Integer && ((Integer) geoid) == -1) {
                XJsonUtils.addStr(result, IEX_MSG, "city not found");
            }
        }
        if (undefined) {
            Object curType = result.get(TicketWidgetType.TYPE);
            String newType = TicketWidgetType.UNDEFINED;
            if (curType instanceof String) {
                String type = (String) curType;
                if (type.equals(REMINDER)) {
                    newType = REMINDER;
                }
                if (type.equals(HOTEL_BOOKING)) {
                    newType = HOTEL_BOOKING;
                }
            }
            result.put(TicketWidgetType.TYPE, newType);
        }
    }

    private void formatDateAndTime(
        final Map<String, Object> x,
        final String keyToFormat)
    {
        if (x.containsKey(keyToFormat)) {
            Object valueToFormat = x.get(keyToFormat);
            if (valueToFormat instanceof String) {
                String strValue = (String) valueToFormat;
                String date = XTimeUtils.formatDate(strValue);
                String time = XTimeUtils.formatTime(strValue);
                if (!date.isEmpty() && !time.isEmpty()) {
                    x.put(keyToFormat, date + ' ' + time);
                }
            }
        }
    }

    private void updateNumberOfNight(
        final long checkInTime,
        final long checkOutTime)
    {
        // number_of_nights
        long difft = checkOutTime - checkInTime;
        long checkInOnlyTime = XTimeUtils.getTimeFromTimestamp(checkInTime);
        if (difft >= 0) {
            if (!result.containsKey(NUMBER_OF_NIGHTS)) {
                // count a dates between Atime and Btime
                // that Xtime is xx.xx.xxxx 0:00 and Atime <= Xtime <= Btime
                long atime = checkInTime;
                long btime = checkOutTime;
                long xtime = atime - checkInOnlyTime;
                long d = XTimeUtils.dayInSeconds(); // 0:00 time is step
                long res = (btime - xtime) / d - (atime - xtime) / d;
                // do not even think about res = (Btime - Atime) / d
                result.put(NUMBER_OF_NIGHTS, res);
            }
        }
    }

    // iex entity hotels
    private boolean extractInfoFromHotelsIexEntity() {
        boolean notEmptySolution = false;
        try {
            List<?> l = null;
            Object hl = json.get(HOTELS);
            if (hl instanceof Map) {
                hl = ((Map) hl).get(HOTELS);
            }
            if (hl instanceof List) {
                l = ValueUtils.asList(hl);
            }
            if (l != null) {
                for (int i = 0; i < l.size(); ++i) {
                    Map<?, ?> m = ValueUtils.asMap(l.get(i));
                    for (Map.Entry<?, ?> entry : m.entrySet()) {
                        String key = ValueUtils.asString(entry.getKey());
                        //String value = ValueUtils.asString(entry.getValue());
                        pushToResult(key, entry.getValue());
                        notEmptySolution = true;
                        //
                    }
                }
            }
        } catch (JsonUnexpectedTokenException e) {
        }
        return notEmptySolution;
    }

    private boolean parsePdfData()
        throws JsonUnexpectedTokenException
    {
        boolean res = false;
        List<String> pdfparts = new LinkedList<>();
        if (json.containsKey(PDF)) {
            Map<?, ?> tmpMp = ValueUtils.asMap(json.get(PDF));
            if (tmpMp.containsKey(HID + PDF)) {
                pdfparts.add(ValueUtils.asString(tmpMp.get(HID + PDF)));
            }
        }
        for (int i = 1; json.containsKey(PDF + i); i++) {
            Map<?, ?> tmpMp = ValueUtils.asMap(json.get(PDF + i));
            if (tmpMp.containsKey(HID + PDF)) {
                pdfparts.add(ValueUtils.asString(tmpMp.get(HID + PDF)));
            }
        }
        attachements = pdfparts;
        return res;
    }

    private void pushToResult(final String key, final Object value) {
        result.put(key, value);
    }

    // iex entity micro
    private boolean extractBookingInfoFromMicroIexEntity()
        throws JsonUnexpectedTokenException
    {
        boolean notEmptySolution = false;
        Object map = XJsonUtils.getSubMapOfKey(json, MICRO);
        if (map == null
            || XJsonUtils.getNodeByPathOrNull(map, UNKNOWN) == null)
        {
            map = XJsonUtils.getSubMapOfKey(json, MICROHTML);
        }
        Object actionMap = null;
        if (map != null && map instanceof Map) {
            map = XJsonUtils.getIfKeyExists(ValueUtils.asMap(map), UNKNOWN);
            if (map instanceof List) {
                List<?> l = ValueUtils.asList(map);
                if (l.size() > 0) {
                    Object tmpMap = ValueUtils.asList(map).get(0);
                    if (l.size() > 1) {
                        actionMap = ValueUtils.asList(map).get(1);
                    }
                    map = tmpMap;
                } else {
                    map = null;
                }
            }
        }
        if (map == null || !(map instanceof Map)) {
            return notEmptySolution;
        }
        if (actionMap != null) {
            Object modifyUrl =
                XJsonUtils.getNodeByPathOrNull(actionMap, "action", URL);
            if (modifyUrl != null && modifyUrl instanceof String) {
                pushToResultKeyMap(MURL, ValueUtils.asString(modifyUrl));
            }
        }
        try {
            actualBookingStructure(ValueUtils.asMap(map));
            notEmptySolution = true;
        } catch (JsonUnexpectedTokenException e) {
            session().logger().log(
                Level.WARNING,
                "In micro Json reservationFor "
                    + "or address field are missing",
                e);
        } catch (Exception e) {
            session().logger().log(
                Level.WARNING,
                "Check uniq_id and domain extraction from an email param",
                e);
        }
        if (result.containsKey(POSTAL)
            && result.containsKey(IEXCOUNTRY)
            && result.containsKey(STREET)
            && result.containsKey(IEXCITY))
        { // addressCountry, postalCode, addressLocality, streetAddress
            pushToResultKeyMap(
                ADDRESS,
                result.get(IEXCOUNTRY)
                    + COMMA + result.get(POSTAL)
                    + COMMA + result.get(IEXCITY)
                    + COMMA + result.get(STREET));
        }
        return notEmptySolution;
    }

    private void actualBookingStructure(final Map<?, ?> hotelsJson)
        throws JsonUnexpectedTokenException
    {
        String[] fieldsInUnknown = {
            RESNUM,
            STATUS,
            CHECKIND,
            CHECKOUTD,
            MURL,
            NUMADULT,
            NUMCHILD,
            PRICE,
            PRICE_CURRENCY
        };
        pushRange(hotelsJson, fieldsInUnknown);
        Map<?, ?> mLevel3reservationFor =
            getMap(hotelsJson, "reservationFor");
        String hostelName =
            getStr(mLevel3reservationFor, HNAME);
        pushToResultKeyMap(HNAME, hostelName);
        Map<?, ?> mLevel4address =
            getMap(mLevel3reservationFor, ADDRESS);
        String[] fieldsInAddress = {
            CITY,
            COUNTRY,
            STREET,
            POSTAL
        };
        pushRange(mLevel4address, fieldsInAddress);
    }

    private void defineReminderParams() {
        try {
            Object resNumValue =
                XJsonUtils.getIfKeyExists(result, IEXRESNUM);
            if (resNumValue != null && resNumValue instanceof String) {
                final String fromDomain = getHotelsDomain();
                final String uniqId =
                    XTools.slowMd5hex((String) resNumValue + fromDomain);
                pushToResult("uniq_id", uniqId);
                pushToResult(DOMAIN, fromDomain);
            }
        } catch (NoSuchAlgorithmException | UnsupportedEncodingException e) {
            XMessageToLog.warning(this, "Error in the slowMd5hex method.");
        }
    }

    private String getHotelsDomain() {
        String fromDomain = "";
        if (email != null) {
            final String[] fromEmail = email.split("@");
            if (fromEmail.length == 2) {
                final String[] urlParts = fromEmail[1].split("\\.");
                if (urlParts.length >= 2) {
                    fromDomain =
                        urlParts[urlParts.length - 2]
                            + '.' + urlParts[urlParts.length - 1];
                }
            }
        }
        return fromDomain;
    }

    private Map<?, ?> getMap(final Map<?, ?> m, final String key)
        throws JsonUnexpectedTokenException
    {
        return ValueUtils.asMap(m.get(key));
    }

    private String getStr(final Map<?, ?> m, final String key) {
        try {
            return ValueUtils.asString(m.get(key));
        } catch (JsonUnexpectedTokenException e) {
            return NULL;
        }
    }

    private void pushRange(final Map<?, ?> m, final String[] range) {
        for (final String s : range) {
            String v = getStr(m, s);
            if (!v.equals(NULL)) {
                pushToResultKeyMap(s, v);
            }
        }
    }

    private void pushToResultKeyMap(final String k, final String v) {
        String key = k;
        String value = v;
        if (MFIELD.containsKey(key)) {
            //rename to IEX field
            key = MFIELD.get(key);
            if (key.equals(IEXPEOPLE)) {
                //sum of numAdults and numChildren
                int sum = 0;
                if (result.containsKey(key)) {
                    if (!isThereAdultOrChildField) {
                        //not sum Iex people
                        //if there is adult or child from micro
                        isThereAdultOrChildField = true;
                    } else {
                        sum += Integer.parseInt((String) result.get(key));
                    }
                }
                sum += Integer.parseInt(value);
                value = String.valueOf(sum);
            }
        }
        pushToResult(key, value);
    }
}
