package ru.yandex.iex.proxy.hotelshandlerlegacy;

import java.util.Map;
import java.util.logging.Level;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.geocoder.GeocoderResult;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.HttpExceptionConverter;
import ru.yandex.http.util.YandexHttpStatus;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;

public class HotelsGeoCallback implements FutureCallback<GeocoderResult> {
    private HotelsContext context;

    public HotelsGeoCallback(final HotelsContext context)
        throws BadRequestException, JsonUnexpectedTokenException
    {
        this.context = context;
    }

    public void completed(final GeocoderResult result) {
        //Input: geo response
        //Output: empty - endpoint
        if (result.size() == 0) {
            context.response();
            return;
        }
        int precise = 0;
        double lat = (result.lowerLatitude(precise)
                + result.upperLatitude(precise)) / 2.0;
        double lon = (result.lowerLongitude(precise)
                + result.upperLongitude(precise)) / 2.0;
        Map<String, Object> sendBack = context.getResult();
        sendBack.put("geocoder_lat", lat);
        sendBack.put("geocoder_lon", lon);
        context.response();
    }

    public void cancelled() {
        this.context.session()
                .logger()
                .warning("Request cancelled: "
                        + this.context.session().listener().details());
        context.session().response(YandexHttpStatus.SC_CLIENT_CLOSED_REQUEST);
    }

    public void failed(final Exception e) {
        this.context.session()
                .logger()
                .log(Level.WARNING, "Failed to process: "
                        + context.humanReadableJson()
                        + '\n' + context.session().listener().details()
                        + " because of exception", e);
        context.session().handleException(
            HttpExceptionConverter.toHttpException(e));
        //TODO; to logger response()
    }
}

