package ru.yandex.iex.proxy.hotelshandlerlegacy;

import java.util.AbstractMap;
import java.util.Map;
import java.util.logging.Level;

import org.apache.http.HttpException;
import org.apache.http.concurrent.FutureCallback;

import ru.yandex.geocoder.GeocoderClient;
import ru.yandex.geocoder.GeocoderRequest;
import ru.yandex.geocoder.GeocoderResult;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.ServerException;
import ru.yandex.http.util.YandexHeaders;
import ru.yandex.http.util.YandexHttpStatus;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.iex.proxy.AbstractEntityHandler;
import ru.yandex.iex.proxy.IexProxy;
import ru.yandex.iex.proxy.XJsonUtils;
import ru.yandex.iex.proxy.XMessageToLog;
import ru.yandex.json.async.consumer.JsonAsyncDomConsumerFactory;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;
import ru.yandex.logger.PrefixedLogger;
import ru.yandex.stater.RequestInfo;
import ru.yandex.stater.RequestsStater;
import ru.yandex.util.timesource.TimeSource;

public class HotelsHandler
    extends AbstractEntityHandler<HotelsContext>
{
    public static final String ADDRESS = "address";
    public static final String CITY = "city";

    public HotelsHandler(final IexProxy iexProxy) {
        super(iexProxy, "hotels");
    }

    @Override
    protected HotelsContext createContext(
        final IexProxy iexProxy,
        final ProxySession session,
        final Map<?, ?> json)
        throws HttpException, JsonUnexpectedTokenException
    {
        return new HotelsContext(iexProxy, session, json);
    }

    @Override
    protected void handle(final HotelsContext context)
        throws JsonUnexpectedTokenException, BadRequestException
    {
        context.getPriceFromXpath();
        context.getCancellationInfoFromXPath();
        if (!context.isResultPerfect()) {
            context.checkXPathSource();
            context.response();
            return;
        }
        GeocoderClient geocoderClient =
            context.iexProxy().geoSearchClient().adjust(
                context.session().context());
        AsyncClient reminderClient =
            context.iexProxy().reminderClient().adjust(
                context.session().context());
        TupleFutureCallback<GeocoderResult, GeocoderResult, Object>
            tupleCallback = new TupleFutureCallback<>(
                context,
                new HotelsTupleCallback(context));
        try {
            Map<String, Object> mergeResult = context.getResult();
            if (mergeResult.containsKey(ADDRESS)) {
                GeocoderRequest request = new GeocoderRequest(
                    context.iexProxy().config().geoSearchConfig());
                request.addHeader(
                    YandexHeaders.X_YA_SERVICE_TICKET,
                    context.iexProxy().geoTvm2Ticket());
                request.setText("адрес " + mergeResult.get(ADDRESS));
                context.session().logger().info(
                    "Send geocoder request address: " + request.getQuery());
                geocoderClient.execute(
                    request,
                    context.session().listener()
                        .createContextGeneratorFor(geocoderClient),
                    tupleCallback.first());
            } else {
                tupleCallback.first().completed(null);
            }
            if (mergeResult.containsKey(CITY)) {
                GeocoderRequest request = new GeocoderRequest(
                    context.iexProxy().config().geoSearchConfig());
                request.addHeader(
                    YandexHeaders.X_YA_SERVICE_TICKET,
                    context.iexProxy().geoTvm2Ticket());
                request.setText("город " + mergeResult.get(CITY));
                context.session().logger().info(
                    "Send geocoder request city: " + request.getQuery());
                geocoderClient.execute(
                    request,
                    context.session().listener()
                        .createContextGeneratorFor(geocoderClient),
                    tupleCallback.second());
            } else {
                tupleCallback.second().completed(null);
            }
            String status = XJsonUtils.getStrValue(
                context.getResult(), "reservationStatus");
            String fullUrl = context.iexProxy().config()
                .reminderConfig().host().getSchemeName()
                + "://" + context.iexProxy().config()
                .reminderConfig().host().getHostName()
                + ':' + context.iexProxy().config()
                .reminderConfig().host().getPort()
                + "/api/v1/" + context.uid()
                + "/reminders/" + context.getClientId();
            if (status.equals("http://schema.org/Confirmed")) {
                tupleCallback.third().completed(null);
            } else if (status.equals("http://schema.org/Cancelled")) {
                // take an intervals from the reminder service
                reminderClient.execute(
                    context.iexProxy().config()
                    .reminderConfig().host(),
                    new BasicAsyncRequestProducerGenerator(fullUrl),
                    JsonAsyncDomConsumerFactory.OK,
                    context.session().listener()
                        .createContextGeneratorFor(reminderClient),
                    tupleCallback.third());
            } else {
                XMessageToLog.warning(context, "Wrong reservationStatus");
                tupleCallback.third().completed(null);
            }
        } catch (BadRequestException e) {
            context.session().logger().log(
                Level.SEVERE,
                "Geocoder request encoding failed",
                e);
            context.response();
        /*} catch (URISyntaxException e) {
            XMessageToLog.error(context, "Reminder error", e);
            context.response();*/
        } catch (Exception e) {
            XMessageToLog.error(context, "Unknown error", e);
            context.response();
        }
    }

    // moved from XTools, TODO refactor this
    private static class TupleFutureCallback<T, U, D> {
        private final Callback<T> first;
        private final Callback<U> second;
        private final Callback<D> third;
        private final FutureCallback<Map.Entry<T, Map.Entry<U, D>>> callback;
        private final PrefixedLogger logger;
        private boolean done = false;

        TupleFutureCallback(
            final HotelsContext context,
            final FutureCallback<Map.Entry<T, Map.Entry<U, D>>> callback)
        {
            this.callback = callback;
            this.first = new Callback<>(context.iexProxy().geoRequestsStater());
            this.second =
                new Callback<>(context.iexProxy().geoRequestsStater());
            this.third = new Callback<>(null);
            this.logger = context.session().logger();
        }

        public FutureCallback<T> first() {
            return first;
        }

        public FutureCallback<U> second() {
            return second;
        }

        public FutureCallback<D> third() {
            return third;
        }

        private class Callback<V> implements FutureCallback<V> {
            private final long start = TimeSource.INSTANCE.currentTimeMillis();
            private boolean subrequestDone = false;
            private V result = null;
            private RequestsStater stater;

            Callback(final RequestsStater stater) {
                this.stater = stater;
            }

            @Override
            public void cancelled() {
                if (stater != null) {
                    stat(YandexHttpStatus.SC_CLIENT_CLOSED_REQUEST);
                    logger.warning("Geocoder request cancelled");
                }
                this.completed(null);
            }

            @Override
            public void failed(final Exception e) {
                if (stater != null) {
                    if (e instanceof ServerException) {
                        stat(((ServerException) e).statusCode());
                    } else {
                        stat(YandexHttpStatus.SC_REMOTE_CLOSED_REQUEST);
                    }
                    logger.log(Level.SEVERE, "Geocoder request failed", e);
                }
                this.completed(null);
            }

            @Override
            public void completed(final V result) {
                if (stater != null && result != null) {
                    stat(YandexHttpStatus.SC_OK);
                }
                synchronized (TupleFutureCallback.this) {
                    if (done) {
                        return;
                    }
                    this.result = result;
                    subrequestDone = true;
                    if (first.subrequestDone == second.subrequestDone
                        && first.subrequestDone == third.subrequestDone)
                    {
                        done = true;
                    } else {
                        return;
                    }
                }
                callback.completed(
                    new AbstractMap.SimpleImmutableEntry<>(
                        first.result,
                        new AbstractMap.SimpleImmutableEntry<>(
                            second.result,
                            third.result)
                    ));
            }

            private void stat(final int status) {
                stater.accept(
                    new RequestInfo(
                        TimeSource.INSTANCE.currentTimeMillis(),
                        status,
                        start,
                        start,
                        0L,
                        0L));
            }
        }
    }
}

