package ru.yandex.iex.proxy.hotelshandlerlegacy;

import java.io.IOException;
import java.util.List;
import java.util.Map;

import org.apache.http.client.methods.HttpDelete;

import ru.yandex.geocoder.GeocoderResult;
import ru.yandex.http.util.YandexHttpStatus;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.iex.proxy.AbstractEntityCallback;
import ru.yandex.iex.proxy.XJsonUtils;
import ru.yandex.iex.proxy.XMessageToLog;
import ru.yandex.iex.proxy.XTimeUtils;
import ru.yandex.json.async.consumer.JsonAsyncDomConsumerFactory;

public class HotelsTupleCallback
    extends AbstractEntityCallback<
            HotelsContext,
            Map.Entry<GeocoderResult, Map.Entry<GeocoderResult, Object>>>
{
    public static final String CITY_GEOID = "city_geoid";
    public static final String ADDRESS_GEOID = "address_geoid";

    HotelsTupleCallback(final HotelsContext context) {
        super(context);
    }

    @Override
    public void completed(
        final Map.Entry<
            GeocoderResult,
            Map.Entry<GeocoderResult, Object>> pairResult)
    {
        GeocoderResult result = pairResult.getKey(); // frist
        if (result != null && result.size() > 0) {
            int precision = 0;
            double lat = (result.lowerLatitude(precision)
                + result.upperLatitude(precision)) / 2.0;
            double lon = (result.lowerLongitude(precision)
                + result.upperLongitude(precision)) / 2.0;
            Map<String, Object> sendBack = context.getResult();
            sendBack.put("geocoder_lat", lat);
            sendBack.put("geocoder_lon", lon);
            if (!sendBack.containsKey(ADDRESS_GEOID)) {
                sendBack.put(ADDRESS_GEOID, result.getGeoid());
            }
        }

        GeocoderResult resultCity = pairResult.getValue().getKey(); // second
        if (resultCity != null) {
            Map<String, Object> sendBack = context.getResult();
            if (!sendBack.containsKey(CITY_GEOID)) {
                sendBack.put(CITY_GEOID, resultCity.getGeoid());
            }
        }

        Object resultReminder = pairResult.getValue().getValue(); // third
        Object cancellEvent =
            XJsonUtils.findObjectValueForKey(resultReminder, "reminders");
        //context.getResult().put("reminder_response", resultReminder);
        if (cancellEvent != null && cancellEvent instanceof List) {
         // cancel a book if both hotels and time are the same
          //  context.getResult().put("cancel", cancellEvent);
            final String cancellingHotel =
                XJsonUtils.getStrValue(context.getResult(), "hotel");
            final String cancellingDate =
                XJsonUtils.getStrValue(context.getResult(), "check-inn_date");
            for (final Object x : (List) cancellEvent) {
                final String reminderHotel =
                    XJsonUtils.findValueForKey(x, "from");
                if (reminderHotel.equals(cancellingHotel)) {
                    String reminderDate =
                        XJsonUtils.findValueForKey(x, "reminderDate");
                    reminderDate = XTimeUtils.minusDays(reminderDate, -1);
                    if (reminderDate.equals(cancellingDate)) {
                        AsyncClient reminderCancellingClient =
                            context.iexProxy().reminderClient().adjust(
                                context.session().context());
                        final String id =
                            XJsonUtils.findValueForKey(x, "id");
                        String fullUrl = context.iexProxy().config()
                            .reminderConfig().host().getSchemeName()
                            + "://" + context.iexProxy().config()
                            .reminderConfig().host().getHostName()
                            + ":80/api/v1/" + context.uid()
                            + "/reminders/" + context.getClientId()
                            + "?id=" + id;
                        try {
                            reminderCancellingClient.execute(
                                context.iexProxy().config()
                                    .reminderConfig().host(),
                                new BasicAsyncRequestProducerGenerator(
                                    new HttpDelete(fullUrl)),
                                JsonAsyncDomConsumerFactory.OK,
                                context.session().listener()
                                    .createContextGeneratorFor(
                                        reminderCancellingClient),
                                new HotelsCancellingCallback(context));
                        } catch (IOException e) {
                            XMessageToLog.warning(
                                context,
                                "DELETE reminder by id error");
                            context.response();
                        } catch (Exception e) {
                            XMessageToLog.warning(
                                context,
                                "Unknown error, look at reminder logic");
                            context.response();
                        }
                        return;
                    }
                }
            }
        }
        if (resultReminder != null && resultReminder instanceof Map) {
            boolean error = XJsonUtils.isThereField(resultReminder, "error");
            if (error) {
                String msg =
                    XJsonUtils.findValueForKey(resultReminder, "message");
                context.session().response(
                    YandexHttpStatus.SC_INTERNAL_SERVER_ERROR,
                    msg);
                return;
            }
        }
        context.response();
    }
}
